/*
 * Created on May 15, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.neptune.widgettoolkit.client.widget.basic;

import com.google.gwt.dom.client.Document;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.SimpleCheckBox;
import com.tandbergtv.neptune.widgettoolkit.client.widget.INeptuneWidget;

/**
 * The toolkit widget extension for the GWT {@link SimpleCheckBox} widget.
 * 
 * @see com.google.gwt.user.client.ui.SimpleCheckBox
 * @author Vijay Silva
 */
public class SimpleCheckBoxWidget extends SimpleCheckBox implements INeptuneWidget {

	/**
	 * Constructor
	 * 
	 * @see com.google.gwt.user.client.ui.SimpleCheckBox#SimpleCheckBox()
	 */
	public SimpleCheckBoxWidget() {
		initializeWidget();
	}

	/**
	 * Constructor
	 * 
	 * @see com.google.gwt.user.client.ui.SimpleCheckBox#SimpleCheckBox(Element)
	 */
	protected SimpleCheckBoxWidget(Element element) {
		super(element);
		initializeWidget();
	}

	/*
	 * Perform any initialization of the widget at the end of construction.
	 */
	private void initializeWidget() {
	}

	/**
	 * Builds a widget wrapping the input element
	 * 
	 * @see com.google.gwt.user.client.ui.SimpleCheckBox#wrap(Element)
	 */
	public static SimpleCheckBoxWidget wrap(Element element) {
		assert Document.get().getBody().isOrHasChild(element);
		SimpleCheckBoxWidget widget = new SimpleCheckBoxWidget(element);
		widget.onAttach();
		RootPanel.detachOnWindowClose(widget);
		return widget;
	}
}
