/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.actionItems.cache;

import com.tandbergtv.neptune.actionItems.cache.ICacheService;
import java.io.Serializable;
import java.util.Collection;
import java.util.ResourceBundle;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;

public class CacheService<T>
implements ICacheService<T> {
    private Cache cache;
    private String name;

    public CacheService(String name) {
        this.name = name;
        ResourceBundle bundle = ResourceBundle.getBundle(this.getClass().getPackage().getName() + ".cache");
        int size = Integer.parseInt(bundle.getString("cache.size"));
        this.cache = new Cache(name, size, false, false, 0L, 0L);
    }

    public CacheService(String name, int size) {
        this.name = name;
        this.cache = new Cache(name, size, false, false, 0L, 0L);
    }

    @Override
    public void add(Serializable key, T entity) {
        this.cache.put(new Element((Object)key, entity));
    }

    @Override
    public T get(Serializable key) {
        Element e = this.cache.get(key);
        if (e == null) {
            return null;
        }
        return (T)e.getValue();
    }

    @Override
    public void remove(Serializable key) {
        this.cache.remove(key);
    }

    @Override
    public Collection<Serializable> getKeys() {
        return this.cache.getKeys();
    }

    @Override
    public int count() {
        return this.cache.getSize();
    }

    @Override
    public void start() {
        CacheManager.getInstance().addCache(this.cache);
    }

    @Override
    public void stop() {
        CacheManager.getInstance().removeCache(this.name);
    }

    @Override
    public String getServiceName() {
        return this.name;
    }
}

