/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.neptune.componentmgr.ejb;

import com.ericsson.neptune.componentmgr.ejb.ComponentValidator;
import com.ericsson.neptune.componentmgr.service.IComponentManager;
import com.tandbergtv.neptune.realm.persist.Component;
import com.tandbergtv.neptune.realm.persist.Module;
import com.tandbergtv.neptune.realm.persist.Permission;
import com.tandbergtv.neptune.realm.persist.Role;
import com.tandbergtv.neptune.realm.persist.SearchMetadata;
import com.tandbergtv.neptune.realm.persist.SearchResult;
import com.tandbergtv.neptune.realm.search.EntitySearchService;
import com.tandbergtv.neptune.validation.ValidationException;
import java.util.List;
import javax.ejb.Local;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;

@Local(value={IComponentManager.class})
@Stateless
public class ComponentManager
implements IComponentManager {
    @PersistenceContext(unitName="NeptuneRealm")
    private EntityManager entityManager;
    private final ComponentValidator validator = new ComponentValidator(this);
    private EntitySearchService<Component> searchService = new EntitySearchService<Component>(Component.class, Component.ID_FIELD_NAME);

    public Component create(Component component) throws ValidationException {
        this.validator.validateComponent(component);
        this.entityManager.persist((Object)component);
        this.entityManager.flush();
        return component;
    }

    public void deleteComponent(String name) {
        Query query = this.entityManager.createNamedQuery("Component.DeleteByName");
        query.setParameter("name", (Object)name);
        query.executeUpdate();
        this.entityManager.flush();
    }

    public void deleteComponent(Long key) {
        Component component = this.getComponent(key);
        this.deleteComponentData(key);
        this.entityManager.remove((Object)component);
    }

    public Component getComponent(Long key) {
        return (Component)this.entityManager.find(Component.class, (Object)key);
    }

    public Component getComponent(String name) {
        Query query = this.entityManager.createNamedQuery("Component.FindByName");
        query.setParameter("name", (Object)name);
        Component component = null;
        try {
            component = (Component)query.getSingleResult();
        }
        catch (NoResultException noResultException) {
            // empty catch block
        }
        return component;
    }

    public List<Component> getComponents() {
        Query query = this.entityManager.createNamedQuery("Component.FindAll");
        return query.getResultList();
    }

    public SearchResult getComponents(SearchMetadata searchMetadata) {
        return this.searchService.getSearchResult(this.entityManager, "component", null, null, searchMetadata);
    }

    public Component update(Component component) throws ValidationException {
        this.validator.validateComponent(component);
        this.entityManager.merge((Object)component);
        this.entityManager.flush();
        return component;
    }

    private void deleteComponentData(Long componentId) {
        Query query = this.entityManager.createNamedQuery("Module.FindAllByComponentId");
        query.setParameter("componentId", (Object)componentId);
        List modules = query.getResultList();
        if (modules != null) {
            for (Object moduleObject : modules) {
                Module module = (Module)moduleObject;
                this.deletePermissions(module);
                this.entityManager.remove((Object)module);
            }
        }
    }

    private void deletePermissions(Module module) {
        for (Permission permission : module.getPermissions()) {
            Query query = this.entityManager.createNamedQuery("Role.FindByPermissionId");
            query.setParameter("permissionId", (Object)permission.getId());
            List roles = query.getResultList();
            for (Object roleObject : roles) {
                ((Role)roleObject).getPermissions().remove(permission);
            }
            permission.getModule().removePermission(permission);
        }
    }
}

