/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.neptune.cluster;

import com.ericsson.cms.neptune.cluster.service.IClusterService;
import com.ericsson.cms.neptune.cluster.service.impl.ClusterService;
import java.io.File;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang.Validate;
import org.apache.log4j.Logger;

public final class Cluster {
    private static final Logger LOGGER = Logger.getLogger(Cluster.class);
    private static final Map<String, IClusterService> services = new ConcurrentHashMap<String, IClusterService>();
    private static Lock lock = new ReentrantLock();

    public static IClusterService getService(String configFile) {
        String path = Cluster.normalizePath(configFile);
        if (services.containsKey(path)) {
            return services.get(path);
        }
        lock.lock();
        try {
            if (!services.containsKey(path)) {
                LOGGER.info((Object)("creating cluster service for " + path));
                services.put(path, Cluster.createCluster(path));
            }
            IClusterService iClusterService = services.get(path);
            return iClusterService;
        }
        finally {
            lock.unlock();
        }
    }

    public static void shutdown() {
        for (IClusterService service : services.values()) {
            service.stop();
        }
        services.clear();
    }

    private static IClusterService createCluster(String path) {
        ClusterService clusterService = new ClusterService(path);
        clusterService.start();
        return clusterService;
    }

    private static String normalizePath(String configFile) {
        Validate.notEmpty((String)configFile);
        return new File(configFile).toString();
    }
}

