/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.neptune.security.authprovider;

import com.ericsson.neptune.security.NeptunePrincipal;
import com.ericsson.neptune.security.User;
import com.ericsson.neptune.security.authprovider.TokenInfo;
import com.ericsson.neptune.security.util.SSLUtil;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class AuthProviderClient {
    private static int CONNECTION_TIMEOUT = 15000;
    private String validateUrl;
    private Logger logger = Logger.getLogger(AuthProviderClient.class);

    public AuthProviderClient() {
        this.disableSSLValidation();
    }

    public void setValidateUrl(String validateUrl) {
        this.validateUrl = validateUrl;
    }

    public TokenInfo validateToken(String token, HttpServletRequest originalRequest) {
        this.logger.debug((Object)"Validating token with provider");
        if (token == null || token.trim().isEmpty() || originalRequest == null) {
            throw new IllegalArgumentException("Token and original request are required");
        }
        try {
            URL url = this.buildValidateUrl(token);
            HttpURLConnection conn = this.makeRequest(url, originalRequest.getCookies());
            String validationResponse = this.readRequestResponse(conn);
            this.logger.debug((Object)("Response: " + validationResponse));
            if (conn.getResponseCode() == 200 && !validationResponse.isEmpty()) {
                return TokenInfo.parse(validationResponse);
            }
            this.logger.warn((Object)("Got invalid response with status " + conn.getResponseCode() + " and response " + validationResponse));
            return null;
        }
        catch (SocketTimeoutException e) {
            this.logger.error((Object)"Connection timed out. ", (Throwable)e);
            return null;
        }
        catch (Exception e) {
            this.logger.error((Object)"Could not validate token with Provider. ", (Throwable)e);
            e.printStackTrace();
            return null;
        }
    }

    public User getUser(String usersWebServiceUrl, HttpServletRequest request, NeptunePrincipal principal) throws MalformedURLException {
        HashMap<String, String> headers = this.getRequestHeaders(request);
        if (!SSLUtil.hasSSLFingerPrint(request) && !this.authorizationHeaderIsPresent(headers) && principal != null && principal.getToken() != null) {
            headers.put("Authorization", "Bearer " + principal.getToken());
        }
        try {
            HttpURLConnection conn = this.makeUsersRequest(usersWebServiceUrl, headers, SSLUtil.hasSSLFingerPrint(request));
            String validationResponse = this.readRequestResponse(conn);
            if (conn.getResponseCode() != 200 || validationResponse == null || validationResponse.isEmpty()) {
                this.logger.error((Object)("Got invalid response from neptune with status " + conn.getResponseCode() + " and response " + validationResponse));
                return null;
            }
            Set<User> users = this.parseUsers(validationResponse);
            if (users == null || users.size() == 0) {
                return null;
            }
            return users.iterator().next();
        }
        catch (Exception e) {
            this.logger.error((Object)"Could get roles from neptune. ", (Throwable)e);
            return null;
        }
    }

    public User getSSLUser(String usersWebServiceUrl) throws MalformedURLException {
        try {
            HttpURLConnection conn = this.makeUsersRequest(usersWebServiceUrl, null, true);
            String validationResponse = this.readRequestResponse(conn);
            if (conn.getResponseCode() != 200 || validationResponse == null || validationResponse.isEmpty()) {
                this.logger.error((Object)("Got invalid response from neptune with status " + conn.getResponseCode() + " and response " + validationResponse));
                return null;
            }
            Set<User> users = this.parseUsers(validationResponse);
            if (users == null || users.size() == 0) {
                return null;
            }
            return users.iterator().next();
        }
        catch (Exception e) {
            this.logger.error((Object)"Could get roles from neptune. ", (Throwable)e);
            return null;
        }
    }

    private Set<User> parseUsers(String validationResponse) throws IOException, JsonParseException, JsonMappingException {
        try {
            ObjectMapper mapper = new ObjectMapper();
            TypeReference<HashMap<String, Set<User>>> jsonUsersNRoles = new TypeReference<HashMap<String, Set<User>>>(){};
            HashMap userrolemap = (HashMap)mapper.readValue(validationResponse.getBytes(), (TypeReference)jsonUsersNRoles);
            Set set = (Set)userrolemap.get("usersAndRoles");
            return set;
        }
        catch (Exception e) {
            this.logger.error((Object)("Got invalid response: " + validationResponse));
            return null;
        }
    }

    private boolean authorizationHeaderIsPresent(HashMap<String, String> headers) {
        for (String headerName : headers.keySet()) {
            if (!headerName.equalsIgnoreCase("Authorization")) continue;
            return true;
        }
        return false;
    }

    private HashMap<String, String> getRequestHeaders(HttpServletRequest request) {
        Enumeration headerNames = request.getHeaderNames();
        HashMap<String, String> headers = new HashMap<String, String>();
        if (headerNames != null) {
            while (headerNames.hasMoreElements()) {
                String headerName = (String)headerNames.nextElement();
                String headerValue = request.getHeader(headerName);
                headers.put(headerName, headerValue);
            }
        }
        return headers;
    }

    private HttpURLConnection makeRequest(URL url, Cookie[] originalRequestCookies) throws IOException, ProtocolException {
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setDoOutput(true);
        conn.setRequestMethod("GET");
        conn.setRequestProperty("Content-Type", "application/text");
        conn.setConnectTimeout(CONNECTION_TIMEOUT);
        conn.setReadTimeout(CONNECTION_TIMEOUT);
        if (originalRequestCookies != null) {
            for (Cookie cookie : originalRequestCookies) {
                conn.addRequestProperty("Cookie", cookie.getName() + "=" + cookie.getValue());
            }
        }
        conn.connect();
        return conn;
    }

    private URL buildValidateUrl(String token) throws MalformedURLException {
        StringBuilder result = new StringBuilder();
        result.append(this.validateUrl);
        result.append("?access_token=");
        result.append(token);
        String resultStr = result.toString();
        this.logger.debug((Object)("Provider url: " + resultStr));
        return new URL(resultStr);
    }

    private void disableSSLValidation() {
        try {
            TrustManager[] trustAllCerts = new TrustManager[]{new TolerantTrustManager()};
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            HostnameVerifier allHostsValid = new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            };
            HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
        }
        catch (NoSuchAlgorithmException e) {
            this.logger.error((Object)"Could nog disable SSL validation", (Throwable)e);
        }
        catch (KeyManagementException e) {
            this.logger.error((Object)"Could nog disable SSL validation", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readRequestResponse(HttpURLConnection conn) {
        BufferedReader reader = null;
        try {
            StringBuilder buff = new StringBuilder();
            reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            String line = null;
            while ((line = reader.readLine()) != null) {
                buff.append(line);
            }
            String string = buff.toString();
            return string;
        }
        catch (IOException e) {
            this.logger.warn((Object)"Could not parse validation response", (Throwable)e);
            String string = "";
            return string;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public HttpURLConnection makeUsersRequest(String usersWebServiceUrl, HashMap<String, String> headers, boolean isSSL) throws IOException, ProtocolException, Exception {
        URL url = new URL(usersWebServiceUrl);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        if (isSSL && conn instanceof HttpsURLConnection) {
            ((HttpsURLConnection)conn).setSSLSocketFactory(SSLUtil.getInstance().getSslSocketFactory());
        }
        conn.setDoOutput(true);
        conn.setRequestMethod("GET");
        conn.setRequestProperty("Content-Type", "application/json");
        if (headers != null) {
            for (Map.Entry<String, String> header : headers.entrySet()) {
                conn.setRequestProperty(header.getKey(), header.getValue());
            }
        }
        conn.connect();
        return conn;
    }

    public String readRequest(HttpServletRequest request) {
        try {
            Map dataMap = request.getParameterMap();
            if (dataMap != null) {
                Iterator itr = dataMap.keySet().iterator();
                String data = (String)itr.next();
                return data;
            }
        }
        catch (Exception e) {
            this.logger.warn((Object)"Could not parse response", (Throwable)e);
        }
        return "";
    }

    public int logoutUser(String logoutUrl, Cookie[] cookies) {
        try {
            URL url = new URL(logoutUrl);
            HttpURLConnection conn = this.makeRequest(url, cookies);
            return conn.getResponseCode();
        }
        catch (SocketTimeoutException e) {
            this.logger.error((Object)"Connection timed out. ", (Throwable)e);
            return -1;
        }
        catch (Exception e) {
            this.logger.error((Object)"Could not complete request to remote component. ", (Throwable)e);
            e.printStackTrace();
            return -1;
        }
    }

    public int sendPostRequest(String destination, String postData, Cookie[] cookies) {
        try {
            URL url = new URL(destination);
            HttpURLConnection conn = this.postRequest(url, postData, cookies);
            return conn.getResponseCode();
        }
        catch (Exception e) {
            this.logger.error((Object)"Failed to post data", (Throwable)e);
            return -1;
        }
    }

    private HttpURLConnection postRequest(URL url, String postData, Cookie[] originalRequestCookies) throws IOException {
        byte[] data = postData.getBytes();
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setDoOutput(true);
        conn.setDoInput(true);
        conn.setRequestMethod("POST");
        conn.setConnectTimeout(CONNECTION_TIMEOUT);
        conn.setReadTimeout(CONNECTION_TIMEOUT);
        conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        conn.setRequestProperty("Content-Length", Integer.toString(data.length));
        conn.setUseCaches(false);
        if (originalRequestCookies != null) {
            for (Cookie cookie : originalRequestCookies) {
                conn.addRequestProperty("Cookie", cookie.getName() + "=" + cookie.getValue());
            }
        }
        DataOutputStream wr = new DataOutputStream(conn.getOutputStream());
        wr.writeBytes(postData);
        wr.flush();
        wr.close();
        return conn;
    }

    static class TolerantTrustManager
    implements X509TrustManager {
        TolerantTrustManager() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) {
        }
    }
}

