package com.tandbergtv.neptune.ui.realm.client.settings.view;

import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.ui.realm.client.settings.service.UiPasswordSetting;
import com.tandbergtv.neptune.ui.realm.client.settings.service.UiSettingDefinition;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.PasswordTextBoxWidget;

public class PasswordInputWidgetWrapper implements SettingsInputWidgetWrapper {

    private PasswordTextBoxWidget widget;
    private UiPasswordSetting setting;
    private String initialValue;
    private String settingName;

    @Override
    public Widget createInputWidget() {
        widget = new PasswordTextBoxWidget();

        if (setting.getMaximumLength() != null) {
            widget.setMaxLength(setting.getMaximumLength().intValue());
        } else {
            widget.setWidth("250px");
        }

        widget.setName(setting.getName());
        if ((initialValue != null) && !initialValue.isEmpty()) {
            widget.setValue(initialValue);
        }
        widget.setTitle(setting.getName());

        return widget;
    }

    @Override
    public String getValue() {
        return widget.getValue();
    }

    @Override
    public String getSettingName() {
        if (settingName == null) {
            return setting.getName();
        } else {
            return settingName;
        }
    }

    @Override
    public void setSettingName(String name) {
        this.settingName = name;
        if (widget != null) {
            widget.setTitle(name);
        }
    }

    @Override
    public SettingsInputWidgetWrapper newInstance() {
        return new PasswordInputWidgetWrapper();
    }

    @Override
    public void setInitialValue(String initialValue) {
        this.initialValue = initialValue;
    }

    @Override
    public void setSettingDefinition(UiSettingDefinition def) {
        this.setting = (UiPasswordSetting) def;
    }

    @Override
    public UiSettingDefinition getSettingDefinition() {
        return setting;
    }
}
