package com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.impl;

import java.util.Map;

import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.anchor.TableAnchor;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.Feature;

public interface FeatureHandler<F extends Feature> {

	/**
	 * Initialize the feature handler. Ensure that any default state required by the feature handler
	 * is set and the view is initialized.
	 */
	void initialize();

	/**
	 * Reset the state of the feature maintained by the feature handler, and also reset the view.
	 * Avoid refreshing the view since the view is refreshed after the list view of the table is
	 * updated based on an asynchronous event.
	 */
	void reset();

	/**
	 * Refresh the view maintained by this feature handler. This method is triggered by the table
	 * after the list view has been refreshed with the new set of records.
	 */
	void refresh();

	/**
	 * Get the anchor tokens used to maintain state required by this feature
	 * 
	 * @return a map of the anchor token name and value
	 */
	Map<String, String> getAnchorTokens();

	/**
	 * Set the anchor that the feature handler can use to initialize the feature state
	 * 
	 * @param anchor The table anchor
	 */
	void setAnchor(TableAnchor anchor);

	/**
	 * Get the feature associated with this feature handler
	 * 
	 * @return The associated feature
	 */
	F getFeature();
}
