package com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.impl;

import static com.google.gwt.user.client.ui.HasVerticalAlignment.ALIGN_MIDDLE;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyCodes;
import com.google.gwt.event.dom.client.KeyPressEvent;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.Window;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableConstants;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.event.PageNavigationEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;

/**
 * Widget which shows Prev and Next links as pagination control
 * 
 * @author spuranik
 *
 */
public class SimplePageFeatureWidget extends PageWidget {

	/* 'Page Navigation' widgets */
	private LabelWidget pageLabelWidget;
	private ImageWidget leftWidget;
	private ImageWidget rightWidget;
	
	@Override
	protected HorizontalContainer buildPageNavigationPanel() {
		HorizontalContainer panel = new HorizontalContainer();
		panel.setVerticalAlignment(ALIGN_MIDDLE);
		panel.setSpacing(TableConstants.NAV_SPACING);

		leftWidget = new ImageWidget();
		leftWidget.setStyleName(TableConstants.STYLE_NAV_BUTTON);
		leftWidget.addClickHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent event) {
				handleGoToPreviousPageClick(event);
			}
		});
		leftWidget.setResource(imageBundle.previousPageDisabled());
		panel.add(leftWidget);

		pageLabelWidget = new LabelWidget("");
		pageLabelWidget.setStyleName(TableConstants.STYLE_GENERAL_TEXT);
		panel.add(pageLabelWidget);

		rightWidget = new ImageWidget();
		rightWidget.setStyleName(TableConstants.STYLE_NAV_BUTTON);
		rightWidget.addClickHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent event) {
				handleGoToNextPageClick(event);
			}
		});
		rightWidget.setResource(imageBundle.nextPageDisabled());
		panel.add(rightWidget);		

		return panel;
	}

	@Override
	protected void handlePageNumberKeyPress(KeyPressEvent event) {
		/* If there is no input, no event is fired */
		if (getInput() == null)
			return;

		/* Determine if a complete page number has been entered */
		if (event.getNativeEvent().getKeyCode() == KeyCodes.KEY_ENTER) {
			int pageNumber = 0;
			try {
				pageNumber = Integer.parseInt(pageNumberWidget.getText());
			} catch (NumberFormatException e) {
				Window.alert(constants.validPageNumberMessage());
				return;
			}

			if (pageNumber <= 0) {
				Window.alert(constants.validPageNumberMessage());
				return;
			}

			/* set the page number as there is no way to identify if it exists or not. */
			setPageNumberText(pageNumber);

			/* Fire event indicating that the page navigation required */
			fireEvent(new PageNavigationEvent(pageNumber, getInput()));
		}
	}

	@Override
	protected void updatePageNavigationPanel() {
		/* Update current page number */
		int currentPage = (getInput() != null) ? getInput().getPageNumber() : DEFAULT_PAGE_NUMBER;
		pageLabelWidget.setText(messages.currentPage(currentPage));

		/* Update the page navigation images */
		ImageResource image = null;
		boolean isLeftEnabled = (currentPage > 1);
		image = isLeftEnabled ? imageBundle.previousPageEnabled() : imageBundle.previousPageDisabled();
		leftWidget.setResource(image);

		boolean isRightEnabled = this.getInput().hasMorePages();
		image = isRightEnabled ? imageBundle.nextPageEnabled() : imageBundle.nextPageDisabled();
		rightWidget.setResource(image);
	}

	/* The 'previous page' button click */
	private void handleGoToPreviousPageClick(ClickEvent event) {
		/* If there is no input, no event is fired */
		if (this.getInput() == null)
			return;

		/* If at first page, ignore */
		if (getInput().getPageNumber() == 1)
			return;

		/* go to prev page */
		int pageNumber = getInput().getPageNumber() - 1;

		/* Fire event indicating that the page navigation required */
		fireEvent(new PageNavigationEvent(pageNumber, getInput()));
	}
	
	/* The 'next page' button click */
	private void handleGoToNextPageClick(ClickEvent event) {
		/* If there is no input, no event is fired */
		if (this.getInput() == null)
			return;

		/* Only if there is more data go to next page else ignore */
		if(this.getInput().hasMorePages()) {
			int pageNumber = this.getInput().getPageNumber() + 1;
			/* Fire event indicating that the page navigation required */
			fireEvent(new PageNavigationEvent(pageNumber, getInput()));
		}
	}
}
