/*
 * Created on Feb 11, 2010
 * 
 * (C) Copyright TANDBERG Television Inc.
 */

package com.tandbergtv.neptune.widgettoolkit.client.widget.event;

import com.google.gwt.event.shared.GwtEvent;

/**
 * Event indicating that the widget is attached to the document.
 * 
 * @author Vijay Silva
 */
public class DocumentAttachEvent extends GwtEvent<DocumentAttachHandler> {

	/* The Handler type */
	private static Type<DocumentAttachHandler> TYPE;

	/**
	 * Gets the type associated with this event.
	 * 
	 * @return returns the handler type
	 */
	public static Type<DocumentAttachHandler> getType() {
		if (TYPE == null) {
			TYPE = new Type<DocumentAttachHandler>();
		}

		return TYPE;
	}

	@Override
	public Type<DocumentAttachHandler> getAssociatedType() {
		return TYPE;
	}

	@Override
	protected void dispatch(DocumentAttachHandler handler) {
		handler.onAttach(this);
	}
}
