/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.usermgmt.external.ldap;

import com.tandbergtv.neptune.realm.persist.UserConfigurationMode;
import com.tandbergtv.neptune.usermgmt.external.IExternalUserProvider;
import com.tandbergtv.neptune.usermgmt.external.IUserAuthenticationService;
import com.tandbergtv.neptune.usermgmt.external.UserConfigurationFactory;
import com.tandbergtv.neptune.usermgmt.external.ldap.LdapConfigurationManager;
import com.tandbergtv.neptune.usermgmt.external.ldap.LdapExternalUserProvider;
import com.tandbergtv.neptune.usermgmt.external.ldap.LdapUserAuthenticationService;
import com.tandbergtv.neptune.usermgmt.external.ldap.conf.ModeType;
import java.io.File;

public class LdapUserConfigurationFactory
extends UserConfigurationFactory {
    private final LdapConfigurationManager configurationManager = this.buildConfigurationManager();
    private static final String CONFIG_FILE_NAME = "ldapConfiguration.xml";

    public UserConfigurationMode getUserConfigurationMode() {
        UserConfigurationMode mode = UserConfigurationMode.External;
        if (ModeType.HYBRID.equals((Object)this.configurationManager.getConfiguration().getMode())) {
            mode = UserConfigurationMode.Hybrid;
        }
        return mode;
    }

    public IUserAuthenticationService createUserAuthenticationService() {
        return new LdapUserAuthenticationService(this.configurationManager);
    }

    public IExternalUserProvider createExternalUserProvider() {
        return new LdapExternalUserProvider(this.configurationManager);
    }

    public boolean allowCreateInternalUser() {
        return this.configurationManager.getConfiguration().isCreateInternalUserAllowed();
    }

    private LdapConfigurationManager buildConfigurationManager() {
        File configDirectory = UserConfigurationFactory.getNeptuneConfigurationDirectory();
        File configFile = new File(configDirectory, CONFIG_FILE_NAME);
        return new LdapConfigurationManager(configFile);
    }
}

