/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.neptune.usermgmt.sync.scan.factory;

import com.ericsson.neptune.security.audit.AbstractAuditManager;
import com.ericsson.neptune.usermgmt.ad.IAdUserManager;
import com.ericsson.neptune.usermgmt.ad.model.UserConverter;
import com.ericsson.neptune.usermgmt.audit.ExternalUserAuditor;
import com.ericsson.neptune.usermgmt.sync.scan.factory.IUserScanWorkerFactory;
import com.ericsson.neptune.usermgmt.sync.scan.worker.BatchLDAPUserScanWorker;
import com.tandbergtv.neptune.realm.persist.User;
import com.tandbergtv.neptune.usermgmt.service.IUserManager;
import java.util.List;

public class LDAPUserScanWorkerFactory
implements IUserScanWorkerFactory {
    private IUserManager userManager;
    private IAdUserManager adUserManager;
    private UserConverter userConverter;
    private AbstractAuditManager auditManager;
    private ExternalUserAuditor userAuditor;

    @Override
    public Runnable createWorker(List<User> batch) {
        if (batch == null || batch.isEmpty()) {
            return null;
        }
        return new BatchLDAPUserScanWorker(batch).setAdUserManager(this.adUserManager).setUserManager(this.userManager).setUserConverter(this.userConverter).setAuditManager(this.auditManager).setUserAuditor(this.userAuditor);
    }

    public void setUserManager(IUserManager userManager) {
        this.userManager = userManager;
    }

    public void setAdUserManager(IAdUserManager adUserManager) {
        this.adUserManager = adUserManager;
    }

    public void setUserConverter(UserConverter userConverter) {
        this.userConverter = userConverter;
    }

    public void setAuditManager(AbstractAuditManager auditManager) {
        this.auditManager = auditManager;
    }

    public void setUserAuditor(ExternalUserAuditor userAuditor) {
        this.userAuditor = userAuditor;
    }
}

