/*
 * Created on Sep 2, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.neptune.widgettoolkit.client.widget.basic;

import com.google.gwt.core.client.JavaScriptObject;
import com.gwtext.client.widgets.form.ComboBox;

/**
 * The toolkit widget extension for the GWT-ext {@link ComboBox} widget.
 * 
 * @author Vijay Silva
 */
public class BasicComboBoxWidget extends ComboBox {

	/**
	 * Constructor
	 * 
	 * @see ComboBox#ComboBox()
	 */
	public BasicComboBoxWidget() {
		initializeWidget();
	}

	/**
	 * Constructor
	 * 
	 * @see ComboBox#ComboBox(String)
	 */
	public BasicComboBoxWidget(String fieldLabel) {
		super(fieldLabel);
		initializeWidget();
	}

	/**
	 * Constructor
	 * 
	 * @see ComboBox#ComboBox(JavaScriptObject)
	 */
	public BasicComboBoxWidget(JavaScriptObject jsObj) {
		super(jsObj);
		initializeWidget();
	}

	/**
	 * Constructor
	 * 
	 * @see ComboBox#ComboBox(String, String)
	 */
	public BasicComboBoxWidget(String fieldLabel, String name) {
		super(fieldLabel, name);
		initializeWidget();
	}

	/**
	 * Constructor
	 * 
	 * @see ComboBox#ComboBox(String, String, int)
	 */
	public BasicComboBoxWidget(String fieldLabel, String name, int width) {
		super(fieldLabel, name, width);
		initializeWidget();
	}

	/*
	 * Perform any initialization of the widget at the end of construction.
	 */
	private void initializeWidget() {
	}
}
