/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.actionItems.cache;

import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.IMap;
import com.hazelcast.partition.MigrationEvent;
import com.hazelcast.partition.MigrationListener;
import com.tandbergtv.neptune.actionItems.cache.AbstractCompositeCache;
import com.tandbergtv.neptune.actionItems.cache.Cluster;
import java.io.Serializable;
import java.util.Collection;

public class ReplicatedCompositeCache<T>
extends AbstractCompositeCache<T> {
    public ReplicatedCompositeCache(String name, int size) {
        super(name, size);
    }

    @Override
    public T get(Serializable key) {
        return this.cache.get(key);
    }

    @Override
    public Collection<Serializable> getKeys() {
        return this.cache.getKeys();
    }

    @Override
    public void start() {
        super.start();
        this.addMapListener();
    }

    protected void addMapListener() {
        IMap map = (IMap)this.getMap();
        map.addEntryListener(new EntryListener<Serializable, T>(){

            public void entryAdded(EntryEvent<Serializable, T> event) {
                if (ReplicatedCompositeCache.this.external(event)) {
                    ReplicatedCompositeCache.this.cache.add((Serializable)event.getKey(), event.getValue());
                }
            }

            public void entryEvicted(EntryEvent<Serializable, T> event) {
                if (ReplicatedCompositeCache.this.external(event)) {
                    ReplicatedCompositeCache.this.cache.remove((Serializable)event.getKey());
                }
            }

            public void entryRemoved(EntryEvent<Serializable, T> event) {
                if (ReplicatedCompositeCache.this.external(event)) {
                    ReplicatedCompositeCache.this.cache.remove((Serializable)event.getKey());
                }
            }

            public void entryUpdated(EntryEvent<Serializable, T> event) {
                if (ReplicatedCompositeCache.this.external(event)) {
                    ReplicatedCompositeCache.this.cache.add((Serializable)event.getKey(), event.getValue());
                }
            }
        }, true);
    }

    @Override
    protected MigrationListener getMigrationListener() {
        return new MigrationListener(){

            public void migrationStarted(MigrationEvent migrationEvent) {
            }

            public void migrationCompleted(MigrationEvent migrationEvent) {
            }
        };
    }

    protected boolean external(EntryEvent<Serializable, T> event) {
        return !Cluster.localMember().equals(event.getMember());
    }
}

