/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.neptune.cluster.config;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;

public abstract class AbstractConfigBuilder<C> {
    protected static final String PROP_INITIAL_WAIT_SECONDS = "hazelcast.initial.wait.seconds";
    protected static final String DEFAULT_DNS_NAME = "app-nodes.service";
    protected String configFile;
    protected String portKey = "host.port";
    protected String discoveryTypeKey = "discovery.type";
    protected String multicastIpKey = "multicast.ip";
    protected String multicastPortKey = "multicast.port";
    protected String unicastHostsKey = "tcpip.hosts";
    protected String hostKey = "host.ip";
    protected String interfaceKey = "host.interface";
    protected String clusterNameKey = "cluster.name";
    protected String clusterPasswordKey = "cluster.password";
    protected String initialWaitKey = "initial.wait";
    protected String autoIncrementKey = "port.auto.increment";
    protected int defaultPort = -1;
    protected boolean isPortAutoIncrement = true;

    public AbstractConfigBuilder(String configFile) {
        this.configFile = configFile;
    }

    public AbstractConfigBuilder<C> portKey(String portKey) {
        this.portKey = portKey;
        return this;
    }

    public AbstractConfigBuilder<C> discoveryTypeKey(String discoveryTypeKey) {
        this.discoveryTypeKey = discoveryTypeKey;
        return this;
    }

    public AbstractConfigBuilder<C> multicastIpKey(String multicastIpKey) {
        this.multicastIpKey = multicastIpKey;
        return this;
    }

    public AbstractConfigBuilder<C> multicastPortKey(String multicastPortKey) {
        this.multicastPortKey = multicastPortKey;
        return this;
    }

    public AbstractConfigBuilder<C> unicastHostsKey(String unicastHostsKey) {
        this.unicastHostsKey = unicastHostsKey;
        return this;
    }

    public AbstractConfigBuilder<C> hostKey(String hostKey) {
        this.hostKey = hostKey;
        return this;
    }

    public AbstractConfigBuilder<C> interfaceKey(String interfaceKey) {
        this.interfaceKey = interfaceKey;
        return this;
    }

    public AbstractConfigBuilder<C> clusterNameKey(String clusterNameKey) {
        this.clusterNameKey = clusterNameKey;
        return this;
    }

    public AbstractConfigBuilder<C> clusterPasswordKey(String clusterPasswordKey) {
        this.clusterPasswordKey = clusterPasswordKey;
        return this;
    }

    public AbstractConfigBuilder<C> initialWaitKey(String initialWaitKey) {
        this.initialWaitKey = initialWaitKey;
        return this;
    }

    public AbstractConfigBuilder<C> autoIncrementKey(String autoIncrementKey) {
        this.autoIncrementKey = autoIncrementKey;
        return this;
    }

    public AbstractConfigBuilder<C> defaultPort(int defaultPort) {
        this.defaultPort = defaultPort;
        return this;
    }

    public AbstractConfigBuilder<C> isPortAutoIncrement(boolean isPortAutoIncrement) {
        this.isPortAutoIncrement = isPortAutoIncrement;
        return this;
    }

    protected InetAddress getAddress() throws IOException {
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        while (interfaces.hasMoreElements()) {
            NetworkInterface ni = interfaces.nextElement();
            Enumeration<InetAddress> addresses = ni.getInetAddresses();
            while (addresses.hasMoreElements()) {
                InetAddress address = addresses.nextElement();
                if (!(address instanceof Inet4Address) || address.isLoopbackAddress()) continue;
                return address;
            }
        }
        return InetAddress.getLocalHost();
    }

    protected InetAddress getIPv4AddressByInterface(String iname) {
        NetworkInterface netInterface = null;
        try {
            netInterface = NetworkInterface.getByName(iname);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (netInterface == null) {
            throw new RuntimeException("Invalid network interface '" + iname + "'");
        }
        Enumeration<InetAddress> addresses = netInterface.getInetAddresses();
        while (addresses.hasMoreElements()) {
            InetAddress address = addresses.nextElement();
            if (!(address instanceof Inet4Address)) continue;
            return address;
        }
        throw new RuntimeException("Could not find IPv4 address for network interface " + iname);
    }

    public abstract C build() throws IOException;
}

