/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.neptune.cluster.config;

import com.ericsson.cms.neptune.cluster.config.AbstractConfigBuilder;
import com.ericsson.cms.neptune.cluster.util.AdvancedProperties;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ClientNetworkConfig;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.log4j.Logger;

public class ClientConfigBuilder
extends AbstractConfigBuilder<ClientConfig> {
    private static final Logger LOGGER = Logger.getLogger(ClientConfigBuilder.class);
    private static final String CLUSTER_NEPTUNE = "/opt/tandbergtv/cms/conf/neptune/cluster.properties";
    private static final String CLUSTER_WORKFLOW = "/opt/tandbergtv/cms/conf/workflow/cluster.properties";

    private ClientConfigBuilder() {
        super(null);
    }

    public ClientConfigBuilder(String configFile) {
        super(configFile);
    }

    public ClientConfigBuilder(String configFile, Map<String, String> defaultProps) {
        super(configFile);
        this.registerDefaultProps(defaultProps);
    }

    private ClientConfig create(AdvancedProperties properties) throws IOException {
        ClientConfig config = new ClientConfig();
        this.configureClusterHost(config, properties);
        this.configureClusterName(config, properties);
        this.configureInitialWait(config, properties);
        return config;
    }

    private void configureInitialWait(ClientConfig config, Properties properties) {
        String wait = properties.getProperty(this.initialWaitKey);
        if (StringUtils.isNotBlank((String)wait)) {
            config.setProperty("hazelcast.initial.wait.seconds", wait);
        }
    }

    private void configureClusterName(ClientConfig config, Properties properties) {
        String name = properties.getProperty(this.clusterNameKey);
        Validate.notEmpty((String)name, (String)(this.clusterNameKey + " cannot be empty"));
        LOGGER.debug((Object)("Cluster name " + name));
        config.getGroupConfig().setName(name);
        String password = properties.getProperty(this.clusterPasswordKey);
        Validate.notEmpty((String)password, (String)(this.clusterPasswordKey + " cannot be empty"));
        config.getGroupConfig().setPassword(password);
    }

    private void configureClusterHost(ClientConfig config, AdvancedProperties properties) throws IOException {
        int port = properties.getInt(this.portKey, "port number");
        String hosts = properties.getProperty(this.unicastHostsKey);
        if (hosts != null) {
            ClientNetworkConfig netConfig = config.getNetworkConfig();
            StringTokenizer tkz = new StringTokenizer(hosts, ",; ");
            while (tkz.hasMoreTokens()) {
                String host = tkz.nextToken();
                try {
                    InetAddress[] ias;
                    if (!StringUtils.isNotBlank((String)host)) continue;
                    LOGGER.debug((Object)("Adding host: " + host));
                    for (InetAddress iAddr : ias = InetAddress.getAllByName(host)) {
                        String addr = iAddr.getHostAddress() + ":" + port;
                        LOGGER.debug((Object)("Adding " + host + " address: " + addr));
                        netConfig.addAddress(new String[]{addr});
                    }
                }
                catch (UnknownHostException ex) {
                    throw new RuntimeException("Unknown host: " + host);
                }
            }
        }
    }

    @Override
    public ClientConfig build() throws IOException {
        AdvancedProperties props = new AdvancedProperties();
        if (!props.loadFromFile(this.configFile)) {
            LOGGER.info((Object)("Could not load settings from file '" + this.configFile + "'. Will try loading from classpath."));
            if (!props.loadFromClassPath(this.configFile)) {
                LOGGER.info((Object)("Could not load settings from class path '" + this.configFile + "'. Will use default settings."));
                this.loadDefaultProperties(this.configFile, props);
            }
        }
        return this.create(props);
    }

    static {
        ClientConfigBuilder config = new ClientConfigBuilder();
        config.registerDefaultProps(CLUSTER_NEPTUNE, config.createDefaultProps("tcpip", "app-nodes.service", "neptune", "neptune", "5950"));
        config.registerDefaultProps(CLUSTER_WORKFLOW, config.createDefaultProps("tcpip", "app-nodes.service", "workflow", "workflow", "5712"));
    }
}

