/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.neptune.cluster.service.impl;

import com.ericsson.cms.neptune.cluster.config.ClientConfigBuilder;
import com.ericsson.cms.neptune.cluster.service.impl.AbstractClusterService;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.core.HazelcastInstance;
import java.io.IOException;

public class ClusterClientService
extends AbstractClusterService {
    private ClientConfig config;

    public ClusterClientService(String configFile) {
        super(configFile);
    }

    public ClusterClientService(ClientConfig config) {
        super(null);
        this.config = config;
    }

    @Override
    protected HazelcastInstance createInstance() {
        try {
            if (this.config == null) {
                this.config = this.createConfig(this.configFile);
            }
            return this.doCreateInstance(this.config);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("error when creating config from file: " + this.configFile, e);
        }
    }

    protected HazelcastInstance doCreateInstance(ClientConfig config) {
        return HazelcastClient.newHazelcastClient((ClientConfig)config);
    }

    protected ClientConfig createConfig(String configFile) throws IOException {
        return new ClientConfigBuilder(configFile).build();
    }
}

