/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.neptune.security.filter.helper;

import com.ericsson.neptune.security.User;
import com.ericsson.neptune.security.authprovider.AuthProviderClient;
import java.net.MalformedURLException;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class UsersCacheManager {
    private static Map<String, User> cachedUsers = new ConcurrentHashMap<String, User>();
    static ScheduledExecutorService executor;
    static Runnable runnable;
    static ScheduledFuture<?> future;
    static int counter;
    static final String webserviceUrl = "https://app:8443/cms/services/users/self";
    private static final String USER_SERVICES = "services";
    protected Logger logger = Logger.getLogger(this.getClass());
    private static UsersCacheManager instance;

    public static synchronized UsersCacheManager getInstance() {
        if (instance == null) {
            instance = new UsersCacheManager();
            instance.synchronize();
        }
        return instance;
    }

    private void synchronize() {
        try {
            if (cachedUsers.isEmpty()) {
                User userNew = this.getUserObject();
                cachedUsers.put(USER_SERVICES, userNew);
            }
        }
        catch (MalformedURLException e) {
            this.logger.error((Object)"Error while getting user from Neptune ", (Throwable)e);
        }
        executor = Executors.newScheduledThreadPool(1);
        runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    User userOld = null;
                    User userNew = UsersCacheManager.this.getUserObject();
                    if (cachedUsers.containsKey(UsersCacheManager.USER_SERVICES)) {
                        userOld = (User)cachedUsers.get(UsersCacheManager.USER_SERVICES);
                    }
                    if (!UsersCacheManager.this.isEqual(userNew, userOld)) {
                        cachedUsers.put(UsersCacheManager.USER_SERVICES, userNew);
                    }
                }
                catch (MalformedURLException e) {
                    UsersCacheManager.this.logger.error((Object)"Error while getting user from Neptune ", (Throwable)e);
                }
                catch (RuntimeException e) {
                    UsersCacheManager.this.logger.error((Object)"Runtime exception occured ", (Throwable)e);
                    throw e;
                }
            }
        };
        future = executor.scheduleWithFixedDelay(runnable, 0L, 300L, TimeUnit.SECONDS);
    }

    protected User getUserObject() throws MalformedURLException {
        AuthProviderClient providerClient = new AuthProviderClient();
        User userNew = providerClient.getSSLUser(webserviceUrl);
        return userNew;
    }

    protected boolean isEqual(User userNew, User userOld) {
        if (userOld == null && userNew == null) {
            return true;
        }
        if (userOld == null) {
            return false;
        }
        if (userNew == null) {
            return true;
        }
        if (userNew.getId() != userOld.getId()) {
            return false;
        }
        if (!userNew.getUserName().equals(userOld.getUserName())) {
            return false;
        }
        if (userNew.getRoleSets().size() != userOld.getRoleSets().size()) {
            return false;
        }
        for (int count = 0; count < userNew.getRoleSets().size(); ++count) {
            HashSet<String> roleSets = new HashSet<String>();
            roleSets.addAll(userNew.getRoleSets());
            roleSets.removeAll(userOld.getRoleSets());
            if (roleSets.size() == 0) continue;
            return false;
        }
        return true;
    }

    public User getUser(String userName) {
        User user = cachedUsers.get(userName);
        return user;
    }

    static {
        counter = 0;
    }
}

