/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.neptune.security.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyStore;
import java.security.SecureRandom;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class SSLUtil {
    public static final String SSL_FINGERPRINT_HEADER = "X-SSL-Client-FINGERPRINT";
    private static Logger logger = Logger.getLogger(SSLUtil.class);
    private static final String SECURITY_DIR = "/var/lib/nobody";
    private static final String KEYSTORE_FILE = "/var/lib/nobody/client_auth_keystore.jks";
    private static final String TRUSTSTORE_FILE = "/var/lib/nobody/cms_truststore.jks";
    private static final String KEYSTORE_PASSWORD_FILE = "/var/lib/nobody/keystore.pass";
    private static final String TRUST_INSTANCE_SUN_X509 = "SunX509";
    private static final String SSL_INSTANCE_TLS = "TLS";
    private static final String STORE_FORMAT_JKS = "JKS";
    private static SSLUtil instance;
    private String password = "";
    private SSLSocketFactory sslSocketFactory;

    public static synchronized SSLUtil getInstance() {
        if (instance == null) {
            instance = new SSLUtil();
        }
        return instance;
    }

    private SSLUtil() {
        try {
            this.sslSocketFactory = this.createSocketFactory();
        }
        catch (Exception e) {
            logger.warn((Object)"Cannot initialize SSLUtil", (Throwable)e);
        }
    }

    public KeyStore loadKeyStore(String storeFormat, String filePath, String password) throws Exception {
        KeyStore keyStore = KeyStore.getInstance(storeFormat);
        FileInputStream fs = null;
        try {
            fs = new FileInputStream(filePath);
            keyStore.load(fs, password.toCharArray());
        }
        catch (FileNotFoundException fe) {
            throw new FileNotFoundException("One or more of keystore/fingerprint files not found.");
        }
        finally {
            if (fs != null) {
                try {
                    fs.close();
                }
                catch (Exception exception) {}
            }
        }
        return keyStore;
    }

    public KeyManagerFactory createKeyManagerFactory(String storeFormat, String filePath, String password) throws Exception {
        KeyStore keyStore = this.loadKeyStore(storeFormat, filePath, password);
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(TRUST_INSTANCE_SUN_X509);
        keyManagerFactory.init(keyStore, password.toCharArray());
        return keyManagerFactory;
    }

    public TrustManagerFactory createTrustManagerFactory(String storeFormat, String filePath, String password) throws Exception {
        KeyStore keyStore = this.loadKeyStore(storeFormat, filePath, password);
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TRUST_INSTANCE_SUN_X509);
        trustManagerFactory.init(keyStore);
        return trustManagerFactory;
    }

    public SSLSocketFactory createSocketFactory() throws Exception {
        KeyManagerFactory kmf = this.createKeyManagerFactory(STORE_FORMAT_JKS, KEYSTORE_FILE, this.getKeystorePassword());
        TrustManagerFactory tmf = this.createTrustManagerFactory(STORE_FORMAT_JKS, TRUSTSTORE_FILE, this.getKeystorePassword());
        SSLContext context = SSLContext.getInstance(SSL_INSTANCE_TLS);
        context.init(kmf.getKeyManagers(), tmf.getTrustManagers(), new SecureRandom());
        return context.getSocketFactory();
    }

    private String getKeystorePassword() {
        if (StringUtils.isBlank((String)this.password)) {
            try {
                this.password = FileUtils.readFileToString((File)new File(KEYSTORE_PASSWORD_FILE)).trim();
            }
            catch (IOException e) {
                logger.warn((Object)"Cannot find password for keystore on the system");
            }
        }
        return this.password;
    }

    public SSLSocketFactory getSslSocketFactory() {
        return this.sslSocketFactory;
    }

    public static boolean hasSSLFingerPrint(HttpServletRequest request) {
        String fingerPrint = request == null ? null : request.getHeader(SSL_FINGERPRINT_HEADER);
        return fingerPrint != null && !"".equals(fingerPrint.trim());
    }
}

