/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.neptune.usermgmt.ad;

import com.ericsson.neptune.usermgmt.ad.AdPropertiesReader;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.PostConstruct;
import org.apache.log4j.Logger;

public class AdPropertiesCache {
    private static Logger logger = Logger.getLogger(AdPropertiesCache.class);
    private AdPropertiesReader adPropertiesReader;
    private AtomicLong lastModified = new AtomicLong(0L);
    private Properties properties = new Properties();

    @PostConstruct
    public void init() {
        this.reload();
    }

    private void reload() {
        long recordedlast;
        long actualLast = this.adPropertiesReader.getConfigFile().lastModified();
        if (actualLast <= (recordedlast = this.lastModified.get())) {
            return;
        }
        if (this.lastModified.compareAndSet(recordedlast, actualLast)) {
            logger.info((Object)"Reloading /opt/tandbergtv/cms/conf/neptune/ActiveDirectory.properties");
            this.properties.putAll((Map<?, ?>)this.adPropertiesReader.getProperties());
        }
    }

    public void setAdPropertiesReader(AdPropertiesReader adPropertiesReader) {
        this.adPropertiesReader = adPropertiesReader;
    }

    public Properties getProperties() {
        this.reload();
        return this.properties;
    }

    public String get(String key) {
        return this.getProperties().getProperty(key);
    }
}

