/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.usermgmt.external.ad;

import com.ericsson.neptune.usermgmt.ad.util.ContextUtil;
import com.tandbergtv.neptune.usermgmt.external.IUserAuthenticationService;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.naming.AuthenticationException;
import javax.naming.directory.InitialDirContext;
import javax.security.auth.login.LoginException;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractActiveDirectoryUserAuthenticationService
implements IUserAuthenticationService {
    public static final String PROP_AD_URL = "ad.url";
    public static final String PROP_AD_DEFAULT_DOMAIN = "ad.defaultDomain";
    private String adUrl;
    private String defaultDomain;

    public AbstractActiveDirectoryUserAuthenticationService(Properties properties) {
        this.adUrl = properties.getProperty(PROP_AD_URL);
        if (StringUtils.isBlank((String)this.adUrl)) {
            throw new RuntimeException("Active Directory URL is not set (ad.url)");
        }
        this.defaultDomain = properties.getProperty(PROP_AD_DEFAULT_DOMAIN);
        if (StringUtils.isBlank((String)this.defaultDomain)) {
            throw new RuntimeException("Default Active Directory domain is not set (ad.defaultDomain)");
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void authenticateAD(String logon, String password) throws LoginException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", this.adUrl);
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", logon);
        env.put("java.naming.security.credentials", password);
        InitialDirContext ctx = null;
        try {
            ctx = new InitialDirContext(env);
        }
        catch (AuthenticationException ex) {
            try {
                throw new LoginException("Invalid user name or password. " + ex);
                catch (Exception ex2) {
                    throw new LoginException("Internal server error. " + ex2);
                }
            }
            catch (Throwable throwable) {
                ContextUtil.closeContextQuietly(ctx);
                throw throwable;
            }
        }
        ContextUtil.closeContextQuietly(ctx);
    }

    protected boolean containsDomain(String str) {
        if (str == null) {
            return false;
        }
        int idx = str.indexOf(92);
        if (idx > 0) {
            return true;
        }
        idx = str.indexOf(64);
        return idx > 0;
    }

    @Override
    public Map<String, String> getProperties() {
        return null;
    }

    @Override
    public void setProperties(Map<String, String> properties) {
    }

    public String getAdUrl() {
        return this.adUrl;
    }

    public String getDefaultDomain() {
        return this.defaultDomain;
    }
}

