package com.tandbergtv.neptune.ui.realm.client.alerts.view;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Timer;
import com.tandbergtv.neptune.ui.realm.client.alerts.service.IAlertsUIService;
import com.tandbergtv.neptune.ui.realm.client.alerts.service.IAlertsUIServiceAsync;
import com.tandbergtv.neptune.ui.realm.client.alerts.service.UiAlertCounts;
import com.tandbergtv.neptune.ui.realm.client.i18n.RealmConstants;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.HyperlinkWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.FlexTableContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.Portlet;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentAttachEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentAttachHandler;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentDetachEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentDetachHandler;

public class AlertMessagesPortlet extends Portlet{

	/* The RPC service */
	private final IAlertsUIServiceAsync service = GWT.create(IAlertsUIService.class);
	private static RealmConstants constants = GWT.create(RealmConstants.class);

	// Table for showing the alerts count for each registered components
	private FlexTableContainer table;
	private Timer refreshTimer;
	private int refreshPeriod;

	public AlertMessagesPortlet(int refreshTimeMillis) {
        super("Action Items");
		this.refreshPeriod = refreshTimeMillis;
        initializeWidget();
	}

	private void initializeWidget() {
		setTitle(constants.alertsStatusPortletHeader());
		setDisplayName(constants.alertsStatusPortletHeader());

		table = new FlexTableContainer();
		table.setStyleName("portlet-alerts"); 
		add(table);

		this.refreshTimer = new Timer() {
			@Override
			public void run() {
				reload();
			}
		};

		EventHandler handler = new EventHandler();
		addDocumentAttachHandler(handler);
		addDocumentDetachHandler(handler);
	}
	
	
	private void reload() {
		service.getAlertCounts(new NeptuneAsyncCallback<UiAlertCounts>() {
			@Override
			public void onNeptuneFailure(Throwable caught) {
				table.clear();
				update();
			}

			@Override
			public void onNeptuneSuccess(UiAlertCounts result) {
				table.clear();
				insertHeader();
				insertRow (1, "ERROR",result.getErrors());
				insertRow (2, "WARNING", result.getWarnings());
				insertRow (3, "INFORMATIONAL", result.getInformationals());
				
				update();
			}});

	}
	
	private void insertHeader(){
		table.setWidget(0,0, new LabelWidget(constants.severityColumnLabel()));
		table.getCellFormatter().setStyleName(0, 0,
				"portlet-tableHeader");
		table.setWidget(0, 1, new LabelWidget(constants.countColumnLabel()));
		table.getCellFormatter().setStyleName(0, 1,
				"portlet-tableHeader");
	}
	
	private void insertRow (int row, String alertType, Integer value) {
		table.setWidget(row, 0, getImage(alertType));
		table.getCellFormatter().setStyleName(row, 0, "portlet-alerts-imgCol");

		
		table.setWidget(row, 1, new HyperlinkWidget(String.valueOf(value),"Admin.Action Items"));
		table.getCellFormatter().setStyleName(row, 1, "portlet-alertCount-nameCol");		
	}
	
	
	static public ImageWidget getImage(String alertType) {
		ImageWidget image = new ImageWidget("/portal/realm/images/icon_rect_" + alertType + ".png");
		image.setTitle(getLocalizedStateName(alertType));
		return image;
	}
	
	static private String getLocalizedStateName(String alertType) {
		return constants.getString(alertType.toLowerCase()+"Label");
	}
	
	/*
	 * Event Handling
	 */
	private final class EventHandler implements DocumentAttachHandler, DocumentDetachHandler {
		@Override
		public void onAttach(DocumentAttachEvent event) {
			refreshTimer.scheduleRepeating(refreshPeriod);
			reload();
		}

		@Override
		public void onDetach(DocumentDetachEvent event) {
			refreshTimer.cancel();
		}
	}	
}
