/*
 * Created on Sep 9, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.impl;

import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.InternalTable;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Record;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.anchor.TableAnchor;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.anchor.TableAnchorChangeEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.anchor.TableAnchorChangeHandler;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.BookmarkFeature;

/**
 * The book mark feature handler
 * 
 * @author Vijay Silva
 */
public class BookmarkFeatureHandler<K, R extends Record<K>> extends
        AbstractFeatureHandler<K, R, BookmarkFeature> {

	/* The anchor event handler */
	private AnchorChangeHandler anchorHandler;

	/**
	 * Constructor
	 */
	public BookmarkFeatureHandler(InternalTable<K, R> table, BookmarkFeature feature) {
		super(table, feature);

		/* Register this handler for events from the table for anchor changes */
		this.anchorHandler = new AnchorChangeHandler();
		getTable().addAnchorChangeHandler(anchorHandler);
	}

	/*
	 * Handle the anchor change from table user events
	 */
	private void handleTableAnchorChange(TableAnchorChangeEvent event) {
		TableAnchor anchor = event.getAnchor();
		String anchorString = getFeature().buildAnchor(anchor);
		if (getTable().getAnchorChangeNotifier() != null) {
			getTable().getAnchorChangeNotifier().anchorChanged(anchorString);
		}
	}

	/**
	 * Handle the anchor change resulting from visiting the anchor.
	 */
	public void handleBrowserAnchorChange(String anchor) {
		TableAnchor tableAnchor = getFeature().parseAnchor(anchor);
		getTable().setTableAnchor(tableAnchor);
	}

	/*
	 * The event handler for anchor events
	 */
	private final class AnchorChangeHandler implements TableAnchorChangeHandler {
		@Override
		public void onAnchorChange(TableAnchorChangeEvent event) {
			handleTableAnchorChange(event);
		}
	}
}
