/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.marvin.engine;

import com.tandbergtv.marvin.actions.Action;
import com.tandbergtv.marvin.actions.Index;
import com.tandbergtv.marvin.actions.NormalizationActions;
import com.tandbergtv.marvin.engine.EvaluatorResults;
import com.tandbergtv.marvin.metadata.ActionAnnotations;
import com.tandbergtv.marvin.udt.ActionMessage;
import com.tandbergtv.marvin.udt.RuleResults;
import com.tandbergtv.marvin.udt.TreAction;
import com.tandbergtv.marvin.udt.TreActionParameterValue;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class Actionator {
    private static final Logger logger = Logger.getLogger(Actionator.class);
    private static String PACKAGE = "com.tandbergtv.marvin.actions";
    private Map<String, Map<String, Method>> methods = new HashMap<String, Map<String, Method>>();

    public Actionator() throws ClassNotFoundException {
        ArrayList<Class<Object>> classes = new ArrayList<Class<Object>>();
        for (String string : Index.getClassList()) {
            Class<Object> clazz = Class.forName(String.valueOf(PACKAGE) + '.' + string);
            if (!Actionator.isAnnotatedClass(clazz)) continue;
            classes.add(clazz);
        }
        for (Class clazz : classes) {
            List<Method> methodList = Actionator.getAnnotatedMethods(clazz);
            HashMap<String, Method> methodMap = new HashMap<String, Method>();
            for (Method method : methodList) {
                String methodSignature = String.valueOf(method.getDeclaringClass().getCanonicalName()) + "." + method.getName() + "(";
                Class<?>[] classArray = method.getParameterTypes();
                int n = classArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Class<?> parameter = classArray[n2];
                    methodSignature = String.valueOf(methodSignature) + parameter.getSimpleName() + ", ";
                    ++n2;
                }
                methodSignature = methodSignature.replaceFirst(", $", ")").replaceFirst("\\($", "()");
                methodMap.put(methodSignature, method);
            }
            this.methods.put(clazz.getName(), methodMap);
        }
    }

    private static List<Method> getAnnotatedMethods(Class<Object> class1) {
        Method[] methods;
        ArrayList<Method> list = new ArrayList<Method>();
        Method[] methodArray = methods = class1.getDeclaredMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (Actionator.isAnnotatedMethod(method)) {
                list.add(method);
            }
            ++n2;
        }
        return list;
    }

    private static boolean isAnnotatedMethod(Method method) {
        Annotation[] annotations;
        Annotation[] annotationArray = annotations = method.getAnnotations();
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            if (annotation instanceof ActionAnnotations.Action) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static boolean isAnnotatedClass(Class<Object> c) {
        Annotation[] annotations;
        Annotation[] annotationArray = annotations = c.getAnnotations();
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            if (annotation instanceof ActionAnnotations) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public Method getMethodFromName(String fqMethodName) {
        int dot = fqMethodName.lastIndexOf(".");
        String className = fqMethodName.substring(0, dot);
        return this.methods.get(className).get(fqMethodName);
    }

    public Class<?> getClassFromName(String fqMethodName) throws ClassNotFoundException {
        int dot = fqMethodName.lastIndexOf(".");
        String className = fqMethodName.substring(0, dot);
        return Class.forName(className);
    }

    public Map<String, Map<String, Method>> getMethods() {
        return this.methods;
    }

    public RuleResults actionate(List<TreAction> actions, Title title, EvaluatorResults evalResults) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, ClassNotFoundException, InstantiationException {
        logger.info((Object)("running actionator: " + title));
        RuleResults rr = new RuleResults(title);
        for (TreAction action : actions) {
            logger.info((Object)("ACTION:" + action.getMethod()));
            Method method = this.getMethodFromName(action.getMethod());
            Object[] params = action.getParams().toArray();
            Object[] outParams = new Object[params.length];
            int i = 0;
            while (i < params.length) {
                TreActionParameterValue tapv = (TreActionParameterValue)params[i];
                if (tapv.getName().equals("title")) {
                    logger.info((Object)("MODIFIED TITLE:" + title));
                    outParams[i] = title;
                    if (method.getDeclaringClass().equals(NormalizationActions.class)) {
                        rr.setModified(true);
                    }
                } else if (tapv.getName().equals("matchedItems")) {
                    logger.info((Object)("ITEMS HAVE BEEN MATCHED:" + evalResults));
                    outParams[i] = evalResults;
                } else {
                    logger.info((Object)"NO MODIFICATIONS");
                    outParams[i] = tapv.getValueAsObject();
                }
                ++i;
            }
            Class<?> myClass = this.getClassFromName(action.getMethod());
            Action actionClass = (Action)myClass.newInstance();
            ActionMessage result = (ActionMessage)method.invoke((Object)actionClass, outParams);
            rr.getMessages().add(result);
            logger.info((Object)("ACTIONATED:" + result));
        }
        rr.setTitle(title);
        return rr;
    }
}

