/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.marvin.engine;

import com.tandbergtv.cms.contentmgmt.service.specification.IAssetSpecificationManager;
import com.tandbergtv.marvin.engine.BooleanDeterminating;
import com.tandbergtv.marvin.engine.ComplexDeterminating;
import com.tandbergtv.marvin.engine.DateDeterminating;
import com.tandbergtv.marvin.engine.EvaluatorException;
import com.tandbergtv.marvin.engine.FloatDeterminating;
import com.tandbergtv.marvin.engine.IDeterminating;
import com.tandbergtv.marvin.engine.LongDeterminating;
import com.tandbergtv.marvin.engine.StringDeterminating;
import com.tandbergtv.marvin.engine.TimeDeterminating;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.watchpoint.pmm.entities.titlefilter.TrePredicate;
import com.tandbergtv.watchpoint.pmm.title.conf.ComplexVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.SimpleVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.Specification;
import com.tandbergtv.watchpoint.pmm.title.conf.Variable;
import javax.ejb.TransactionAttribute;
import org.apache.log4j.Logger;

public class DeterminatingFactory {
    private static final Logger logger = Logger.getLogger(DeterminatingFactory.class);
    private static IAssetSpecificationManager specManager = (IAssetSpecificationManager)InjectionUtil.injectInstance((String)"cms/AssetSpecificationManager/local", IAssetSpecificationManager.class);

    @TransactionAttribute
    public static IDeterminating getDeterminating(TrePredicate predicate, Field field) throws EvaluatorException {
        return DeterminatingFactory.getDeterminatingHelper(predicate, field);
    }

    public static IDeterminating getDeterminating(TrePredicate predicate, Asset asset) throws EvaluatorException {
        return new ComplexDeterminating(predicate, asset);
    }

    public static IDeterminating getDeterminating(TrePredicate predicate) throws EvaluatorException {
        return DeterminatingFactory.getDeterminatingHelper(predicate, null);
    }

    private static IDeterminating getDeterminatingHelper(TrePredicate predicate, Field field) throws EvaluatorException {
        if (predicate.getFieldLeft() == null || predicate.getFieldLeft().equals(predicate.getFieldLeftSectionType())) {
            return new ComplexDeterminating(predicate, field);
        }
        Variable variable = DeterminatingFactory.getVariable(predicate);
        if (variable instanceof ComplexVariable) {
            return new ComplexDeterminating(predicate, field);
        }
        if (variable.getClass().getSuperclass().equals(SimpleVariable.class)) {
            String dataType = ((SimpleVariable)variable).getDataType();
            if (dataType.equals("boolean")) {
                return new BooleanDeterminating(predicate, field);
            }
            if (dataType.equalsIgnoreCase("string")) {
                return new StringDeterminating(predicate, field);
            }
            if (dataType.equalsIgnoreCase("date")) {
                return new DateDeterminating(predicate, field);
            }
            if (dataType.equalsIgnoreCase("float")) {
                return new FloatDeterminating(predicate, field);
            }
            if (dataType.equalsIgnoreCase("integer")) {
                return new LongDeterminating(predicate, field);
            }
            if (dataType.equalsIgnoreCase("time")) {
                return new TimeDeterminating(predicate, field);
            }
            throw new EvaluatorException("unknown operator: " + dataType);
        }
        throw new EvaluatorException("Could not determine data type.");
    }

    private static Variable getVariable(TrePredicate predicate) throws EvaluatorException {
        String assetType = predicate.getFieldLeftSectionType();
        String xpath = predicate.getFieldLeft();
        Specification spec = specManager.getDefaultSpecification();
        return spec.getTitleConfByName(assetType).getMetadataVariableByXPath(xpath);
    }
}

