/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.marvin.engine;

import com.tandbergtv.marvin.engine.DeterminatingFactory;
import com.tandbergtv.marvin.engine.EvaluatorException;
import com.tandbergtv.marvin.engine.IDeterminating;
import com.tandbergtv.marvin.engine.IllegalOperationException;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.watchpoint.pmm.entities.titlefilter.TreLogicalOperator;
import com.tandbergtv.watchpoint.pmm.entities.titlefilter.TrePredicate;
import org.apache.log4j.Logger;

public class Determinator {
    private static final Logger logger = Logger.getLogger(Determinator.class);

    public static boolean determine(TrePredicate predicate, Field field) throws EvaluatorException, IllegalOperationException {
        IDeterminating determinating = DeterminatingFactory.getDeterminating(predicate, field);
        boolean evalationResult = Determinator.callDeterminatingMethod(predicate, determinating);
        Determinator.logResults(predicate, evalationResult);
        return evalationResult;
    }

    public static boolean determine(TrePredicate predicate, Asset asset) throws IllegalOperationException, EvaluatorException {
        IDeterminating determinating = DeterminatingFactory.getDeterminating(predicate, asset);
        boolean evalationResult = Determinator.callDeterminatingMethod(predicate, determinating);
        Determinator.logResults(predicate, evalationResult);
        return evalationResult;
    }

    public static boolean determine(TrePredicate predicate) throws IllegalOperationException, EvaluatorException {
        IDeterminating determinating = DeterminatingFactory.getDeterminating(predicate);
        boolean evalationResult = Determinator.callDeterminatingMethod(predicate, determinating);
        Determinator.logResults(predicate, evalationResult);
        return evalationResult;
    }

    public static void logResults(TrePredicate predicate, boolean result) {
        logger.info((Object)(String.valueOf(predicate.getFieldLeft()) + " " + predicate.getOperator() + "==" + result));
    }

    private static boolean callDeterminatingMethod(TrePredicate predicate, IDeterminating determinating) throws IllegalOperationException, EvaluatorException {
        TreLogicalOperator operator = predicate.getOperator();
        switch (operator) {
            case EQUAL: {
                return determinating.equal();
            }
            case LESSTHAN: {
                return determinating.lessThan();
            }
            case GREATERTHAN: {
                return determinating.greaterThan();
            }
            case LESSTHANEQUAL: {
                return determinating.lessThanEqual();
            }
            case GREATERTHANEQUAL: {
                return determinating.greaterThanEqual();
            }
            case ISEMPTY: {
                return determinating.isEmpty();
            }
            case ISNOTEMPTY: {
                return determinating.isNotEmpty();
            }
            case NOTEQUAL: {
                return determinating.notEqual();
            }
            case CONTAINS: {
                return determinating.contains();
            }
            case DOESNOTCONTAIN: {
                return determinating.doesNotContain();
            }
            case IN: {
                return determinating.in();
            }
            case NOTIN: {
                return determinating.notIn();
            }
            case LENGTHEQUALS: {
                return determinating.lengthEquals();
            }
            case LENGTHLESSTHAN: {
                return determinating.lengthLessThan();
            }
            case LENGTHGREATERTHAN: {
                return determinating.lengthGreaterThan();
            }
            case REGEX: {
                return determinating.regex();
            }
            case STARTSWITH: {
                return determinating.startsWith();
            }
            case ENDSWITH: {
                return determinating.endsWith();
            }
            case GREATERTHANTODAY: {
                return determinating.greaterThanToday();
            }
            case LESSTHANTODAY: {
                return determinating.lessThanToday();
            }
            case CONTAINSUNPARSABLE: {
                return determinating.containsUnparsable();
            }
            case TIER1EQUALS: {
                return determinating.tierEquals(1);
            }
            case TIER2EQUALS: {
                return determinating.tierEquals(2);
            }
            case TIER3EQUALS: {
                return determinating.tierEquals(3);
            }
            case TIER4EQUALS: {
                return determinating.tierEquals(4);
            }
        }
        String msg = "cannot get determinator: " + operator;
        logger.error((Object)msg);
        throw new EvaluatorException(msg);
    }
}

