/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.marvin.engine;

import com.tandbergtv.marvin.engine.IDeterminating;
import com.tandbergtv.marvin.engine.IllegalOperationException;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.watchpoint.pmm.entities.titlefilter.TrePredicate;
import com.tandbergtv.watchpoint.pmm.entities.titlefilter.TrePredicateRightValue;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class StringDeterminating
implements IDeterminating {
    private String value;
    private List<String> comparison;
    private Field field;

    public StringDeterminating(TrePredicate predicate, Field field) {
        if (predicate instanceof TrePredicateRightValue) {
            TrePredicateRightValue rightPred = (TrePredicateRightValue)predicate;
            this.comparison = rightPred.getValue();
        }
        this.value = field != null ? field.getValue() : null;
        this.field = field;
        if (this.isNotEmpty() && predicate.getIgnoreCase()) {
            this.convertCase();
        }
    }

    private void convertCase() {
        this.value = this.value.toUpperCase();
        this.comparison = new ArrayList<String>(this.comparison);
        int i = 0;
        while (i < this.comparison.size()) {
            this.comparison.set(i, this.comparison.get(i).toUpperCase());
            ++i;
        }
    }

    @Override
    public boolean equal() {
        return this.value != null && this.value.equals(this.comparison.get(0));
    }

    @Override
    public boolean greaterThan() throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean in() {
        if (this.value != null) {
            for (String compVal : this.comparison) {
                if (!this.value.equals(compVal)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean lessThan() throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean contains() {
        for (String compVal : this.comparison) {
            if (this.value == null || !this.value.contains(compVal)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean notEqual() {
        return !this.equal();
    }

    @Override
    public boolean notIn() {
        return !this.in();
    }

    @Override
    public boolean greaterThanEqual() throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean isEmpty() {
        return this.value == null || this.value.isEmpty();
    }

    @Override
    public boolean isNotEmpty() {
        return this.value != null && !this.value.isEmpty();
    }

    @Override
    public boolean lessThanEqual() throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean lengthEquals() throws IllegalOperationException {
        return this.value != null && this.value.length() == this.getComparisonLength();
    }

    @Override
    public boolean lengthGreaterThan() throws IllegalOperationException {
        return this.value != null && this.value.length() > this.getComparisonLength();
    }

    @Override
    public boolean lengthLessThan() throws IllegalOperationException {
        return this.value != null && this.value.length() < this.getComparisonLength();
    }

    @Override
    public boolean regex() throws IllegalOperationException {
        boolean regex = false;
        try {
            regex = this.value.matches(this.comparison.get(0));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.value != null && regex;
    }

    private int getComparisonLength() throws IllegalOperationException {
        long length;
        block5: {
            block4: {
                String str = this.comparison.get(0);
                try {
                    length = Long.parseLong(str);
                    if (length <= Integer.MAX_VALUE) break block4;
                    return Integer.MAX_VALUE;
                }
                catch (NumberFormatException e) {
                    throw new IllegalOperationException("Illegal Number! " + str);
                }
            }
            if (length >= Integer.MIN_VALUE) break block5;
            return Integer.MIN_VALUE;
        }
        return (int)length;
    }

    @Override
    public boolean startsWith() throws IllegalOperationException {
        return this.value != null && this.value.startsWith(this.comparison.get(0));
    }

    @Override
    public boolean endsWith() throws IllegalOperationException {
        return this.value != null && this.value.endsWith(this.comparison.get(0));
    }

    @Override
    public boolean greaterThanToday() throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean lessThanToday() throws IllegalOperationException {
        throw new IllegalOperationException();
    }

    @Override
    public boolean containsUnparsable() {
        if (this.field == null) {
            return false;
        }
        return this.field.getParsable() == false;
    }

    @Override
    public boolean doesNotContain() throws IllegalOperationException {
        return !this.contains();
    }

    @Override
    public boolean tierEquals(int tier) throws IllegalOperationException {
        if (this.isEmpty()) {
            return false;
        }
        StringTokenizer tokenizer = new StringTokenizer(this.value, "/");
        int currTier = 1;
        while (currTier < tier && tokenizer.hasMoreTokens()) {
            tokenizer.nextToken();
            ++currTier;
        }
        if (currTier == tier && tokenizer.hasMoreTokens()) {
            return tokenizer.nextToken().equals(this.comparison.get(0));
        }
        return false;
    }
}

