/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.marvin.metadata;

import com.tandbergtv.marvin.metadata.SchemaNode;
import java.util.HashMap;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SchemaThingHelper {
    HashMap<String, SchemaNode> basemap = new HashMap();
    HashMap<String, SchemaNode> map = new HashMap();
    Document doc;
    String prefix = "tns:";

    private boolean isSimpleType(Element node) {
        return !node.getAttribute("type").startsWith(this.prefix);
    }

    private void populate(String filepath) throws Exception {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        this.doc = docBuilder.parse(this.getClass().getResourceAsStream(filepath));
    }

    private SchemaNode getBaseSchemaNode(Element elem) {
        String s = elem.getAttribute("type").startsWith(this.prefix) ? elem.getAttribute("type").substring(this.prefix.length()) : elem.getAttribute("type");
        return this.basemap.get(s);
    }

    private boolean checkParent(SchemaNode node, SchemaNode child) {
        if (node != null) {
            if (node.getNodeName().equals(child.getNodeName())) {
                return true;
            }
            this.checkParent(node.getParent(), child);
        }
        return false;
    }

    private void resolveChildren() {
        NodeList nodes = this.doc.getElementsByTagName("complexType");
        int i = 0;
        while (i < nodes.getLength()) {
            Element e = (Element)nodes.item(i);
            SchemaNode schemaNode = new SchemaNode(e);
            this.resolveAttributes(e);
            this.basemap.put(schemaNode.getQName(), schemaNode);
            ++i;
        }
        for (SchemaNode parent : this.basemap.values()) {
            this.resolveChild(parent);
        }
    }

    private void resolveChild(SchemaNode parent) {
        if (parent == null) {
            return;
        }
        NodeList children = parent.getElem().getElementsByTagName("element");
        int j = 0;
        while (j < children.getLength()) {
            SchemaNode child;
            Element seq = (Element)children.item(j);
            if (!this.isSimpleType(seq)) {
                child = this.getBaseSchemaNode(seq);
                if (child != null && !this.checkParent(parent, child)) {
                    parent.addChild(child);
                    child.setSimpleType(false);
                    this.map.put(child.getQName(), child);
                    this.resolveChild(child);
                }
            } else {
                child = new SchemaNode(seq.getAttribute("name"));
                parent.addChild(child);
                child.setMappedClass(this.resolveSimpleType(seq.getAttribute("type")));
                child.setSimpleType(true);
                this.map.put(child.getQName(), child);
            }
            ++j;
        }
    }

    private void resolveAttributes(Element e) {
    }

    private void resolveComplexType(String pkgname) {
        for (SchemaNode node : this.basemap.values()) {
            String s = String.valueOf(pkgname) + "." + node.getNodeName();
            if (node.getMappedClass() != null) continue;
            try {
                String suffix = "ComplexType";
                if (s.endsWith(suffix)) {
                    int strEndIndex = s.length() - suffix.length();
                    s = s.substring(0, strEndIndex);
                }
                Class<Object> c = Class.forName(s);
                node.setMappedClass(c);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private Class resolveSimpleType(String type) {
        try {
            if (type.equals("boolean")) {
                return Class.forName("java.lang.Boolean");
            }
            if (type.equals("float")) {
                return Class.forName("java.lang.Float");
            }
            if (type.equals("integer")) {
                return Class.forName("java.lang.Integer");
            }
            if (type.equals("nonNegativeInteger")) {
                return Class.forName("java.lang.Integer");
            }
            if (type.equals("string")) {
                return Class.forName("java.lang.String");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String reverseStringByToken(String test, String token) {
        Stack<String> stack = new Stack<String>();
        StringTokenizer strTok = new StringTokenizer(test, token);
        while (strTok.hasMoreTokens()) {
            stack.push((String)strTok.nextElement());
        }
        StringBuffer revStr = new StringBuffer();
        while (!stack.empty()) {
            revStr.append((String)stack.pop());
            revStr.append(token);
        }
        return revStr.toString();
    }

    protected HashMap<String, SchemaNode> getMap(String filepath, String pkgname) throws Exception {
        this.populate(filepath);
        this.resolveChildren();
        this.resolveComplexType(pkgname);
        return this.map;
    }

    protected void setPrefix(String prefix) {
        this.prefix = prefix;
    }
}

