/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.marvin.rules.action;

import com.tandbergtv.marvin.rules.action.ValidationMessageType;
import java.util.ArrayList;
import java.util.List;

public class ValidationActions {
    private List<ValidationMessage> messages = new ArrayList<ValidationMessage>();

    public void raiseWarning(String message) {
        this.raiseMessage(ValidationMessageType.Warning, message);
    }

    public void raiseWarning(String message, String xpath) {
        this.raiseMessage(ValidationMessageType.Warning, message, xpath);
    }

    public void raiseError(String message) {
        this.raiseMessage(ValidationMessageType.Error, message);
    }

    public void raiseError(String message, String xpath) {
        this.raiseMessage(ValidationMessageType.Error, message, xpath);
    }

    public void raiseInfo(String message) {
        this.raiseMessage(ValidationMessageType.Info, message);
    }

    public void raiseInfo(String message, String xpath) {
        this.raiseMessage(ValidationMessageType.Info, message, xpath);
    }

    private void raiseMessage(ValidationMessageType messageType, String message, String xpath) {
        this.messages.add(new ValidationMessage(messageType, message, xpath));
    }

    private void raiseMessage(ValidationMessageType messageType, String message) {
        this.messages.add(new ValidationMessage(messageType, message));
    }

    public void printMessages() {
        for (ValidationMessage message : this.messages) {
            System.out.println(String.valueOf(message.messageType.toString()) + ": " + message.getMessage());
        }
    }

    public void setMessages(List<ValidationMessage> messages) {
        this.messages = messages;
    }

    public List<ValidationMessage> getMessages() {
        return this.messages;
    }

    public class ValidationMessage {
        private ValidationMessageType messageType;
        private String xpath;
        private String message;

        public ValidationMessage(ValidationMessageType messageType, String message) {
            this.messageType = messageType;
            this.message = message;
        }

        public ValidationMessage(ValidationMessageType messageType, String message, String xpath) {
            this.messageType = messageType;
            this.xpath = xpath;
            this.message = message;
        }

        public void setMessageType(ValidationMessageType messageType) {
            this.messageType = messageType;
        }

        public ValidationMessageType getMessageType() {
            return this.messageType;
        }

        public void setXpath(String xpath) {
            this.xpath = xpath;
        }

        public String getXpath() {
            return this.xpath;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

