/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.marvin.udt;

import java.util.regex.Pattern;
import org.junit.Test;

public class StringLikeRegex {
    public static final int EQUAL = 0;
    public static final int START = 1;
    public static final int END = 2;
    public static final int CONTAINS = 3;

    @Test
    public void testReplace() {
        String textNon = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam molestie viverra mollis.";
        String textQui = "Duis linguist nunc feugiat velit faucibus semper molestie libero suscipit. ";
        String[] tests = new String[]{"cunninglinguist", "linguistspeak", "cunninglinguistspeak", textNon, textQui};
        String[] clauses = new String[]{"linguist", "%linguist", "linguist%", "%linguist%", "!linguist!", "!%linguist", "linguist!%", "!%linguist!%"};
        int h = 0;
        while (h < tests.length) {
            int i = 0;
            while (i < clauses.length) {
                StringLikeRegex.replaceRegEx(clauses[i], tests[h]);
                ++i;
            }
            ++h;
        }
    }

    @Test
    public void validRegexTest() {
        String[] compares = new String[]{"", "hello world", "hello 02", "Thu 10:13 PM"};
        String regex1 = "^([01][0-9][0-9]|2[0-4][0-9]|25[0-5])$";
        String regex2 = "^.*\b(one|two|three)\b.*$";
        String regex3 = "1";
        this.showValidRegex(regex1, compares);
        this.showValidRegex(regex2, compares);
        this.showValidRegex(regex3, compares);
    }

    private void showValidRegex(String s, String[] compare) {
        System.out.println(String.valueOf(s) + ": ");
        System.out.println("Compiles: " + this.isValidRegex(s));
        int i = 0;
        while (i < compare.length) {
            System.out.print("Executes: " + this.regex(s, compare[i]));
            System.out.println("(" + compare[i] + ")");
            ++i;
        }
    }

    private boolean isValidRegex(String s) {
        try {
            Pattern.compile(s);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean regex(String value, String comparison) {
        return value != null && value.matches(comparison);
    }

    private static boolean replaceRegEx(String s, String match) {
        StringBuffer buf = new StringBuffer(s.length());
        if (!s.startsWith("!%") && s.startsWith("%") && !s.endsWith("!%") && s.endsWith("%")) {
            buf.append(s.substring(1));
            buf.deleteCharAt(s.length() - 2);
            System.out.println(String.valueOf(s) + " contains " + match + "==" + match.contains(buf));
            return match.contains(buf);
        }
        if (!s.startsWith("!%") && s.startsWith("%")) {
            buf.append(s.substring(1));
            System.out.println(String.valueOf(s) + " starts " + match + "==" + match.startsWith(buf.toString()));
            return match.startsWith(buf.toString());
        }
        if (!s.endsWith("!%") && s.endsWith("%")) {
            buf.append(s);
            buf.deleteCharAt(s.length() - 1);
            System.out.println(String.valueOf(s) + " ends " + match + "==" + match.endsWith(buf.toString()));
            return match.endsWith(buf.toString());
        }
        return false;
    }
}

