/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.rules.ui.client.common;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.ui.title.client.criteria.Validatable;
import com.tandbergtv.cms.rules.ui.client.RulesConstants;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.CheckBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

public class RuleNamePanel
extends VerticalContainer
implements Validatable {
    protected TextBoxWidget txtRuleName;
    protected RulesConstants myConstants = (RulesConstants)GWT.create(RulesConstants.class);
    protected boolean hasBeenValidatedBefore = false;
    private CheckBoxWidget ruleEnabled = new CheckBoxWidget();
    private VerticalContainer warningMessages = new VerticalContainer();
    private HorizontalContainer mainContainer = new HorizontalContainer();

    public RuleNamePanel() {
        this.ruleEnabled.setValue(Boolean.valueOf(true));
        this.putUiTogether();
    }

    public RuleNamePanel(String ruleName, boolean enabled) {
        this.putUiTogether();
        this.txtRuleName.setValue(ruleName);
        this.ruleEnabled.setValue(Boolean.valueOf(enabled));
    }

    protected void putUiTogether() {
        this.add((Widget)this.warningMessages);
        this.add((Widget)this.mainContainer);
        LabelWidget labelRule = new LabelWidget(this.myConstants.ruleNameLabel());
        this.txtRuleName = new TextBoxWidget();
        this.txtRuleName.setMaxLength(255);
        this.mainContainer.add((Widget)labelRule);
        this.mainContainer.add((Widget)this.txtRuleName);
        this.ruleEnabled.setText(this.myConstants.enabledLabel());
        this.mainContainer.add((Widget)this.ruleEnabled);
        this.setCellHorizontalAlignment((Widget)this.mainContainer, HasHorizontalAlignment.ALIGN_LEFT);
    }

    public boolean validate() {
        this.clearWarningMessages();
        if (this.txtRuleName.getText().equals("")) {
            this.addWaringMessage(this.myConstants.ruleNameRequired());
            this.txtRuleName.setStyleName("pinkbox");
            if (!this.hasBeenValidatedBefore) {
                this.txtRuleName.addChangeHandler(new ChangeHandler(){

                    public void onChange(ChangeEvent event) {
                        RuleNamePanel.this.clearWarningMessages();
                        RuleNamePanel.this.txtRuleName.setStyleName("whitebox");
                    }
                });
            }
            return false;
        }
        return true;
    }

    public String getRuleName() {
        return this.txtRuleName.getText();
    }

    public boolean isEnabled() {
        return this.ruleEnabled.getValue();
    }

    public void setEnabled(boolean enabled) {
        this.ruleEnabled.setValue(Boolean.valueOf(enabled));
    }

    public CheckBoxWidget getRuleEnabled() {
        return this.ruleEnabled;
    }

    private void addWaringMessage(String msg) {
        LabelWidget message = new LabelWidget(msg);
        message.addStyleName("red-txt");
        this.warningMessages.add((Widget)message);
    }

    private void clearWarningMessages() {
        this.warningMessages.clear();
    }
}

