/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.rules.ui.client.common.rulelisting;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.rules.ui.client.RulesComponent;
import com.tandbergtv.cms.rules.ui.client.RulesConstants;
import com.tandbergtv.cms.rules.ui.client.UiRulesService;
import com.tandbergtv.cms.rules.ui.client.UiRulesServiceAsync;
import com.tandbergtv.cms.rules.ui.client.common.MessageContainer;
import com.tandbergtv.cms.rules.ui.client.common.Permissions;
import com.tandbergtv.cms.rules.ui.client.common.RulePanel;
import com.tandbergtv.cms.rules.ui.client.common.RulePanelFactory;
import com.tandbergtv.cms.rules.ui.client.common.RulesConfirmation;
import com.tandbergtv.cms.rules.ui.client.common.RulesUiException;
import com.tandbergtv.cms.rules.ui.client.common.events.ConfirmationEvent;
import com.tandbergtv.cms.rules.ui.client.common.events.ConfirmationHandler;
import com.tandbergtv.cms.rules.ui.client.common.rulelisting.OrderableTable;
import com.tandbergtv.cms.rules.ui.client.common.rulelisting.TableRow;
import com.tandbergtv.cms.rules.ui.client.data.Packages;
import com.tandbergtv.cms.rules.ui.client.data.UIRuleListItem;
import com.tandbergtv.cms.rules.ui.client.data.UIRuleSet;
import com.tandbergtv.cms.rules.ui.client.ruleServiceErrorHandling.ErrorMessageBuilder;
import com.tandbergtv.cms.rules.ui.client.ruleServiceErrorHandling.RuleServiceException;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.HTMLWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class RulesListingPanel
extends VerticalContainer
implements WidgetMenuItem.AnchorChangeListener {
    private UiRulesServiceAsync rulesService = (UiRulesServiceAsync)GWT.create(UiRulesService.class);
    private RulesConstants constants = RulesComponent.getInstance().getConstants();
    private OrderableTable table;
    private MessageContainer messageContainer;
    private Packages pkgType;
    private HorizontalContainer buttonContainer;
    private BusyIndicator busyIndicator;

    public RulesListingPanel(Packages packages) {
        this.pkgType = packages;
        this.messageContainer = new MessageContainer();
        this.buttonContainer = new HorizontalContainer();
        this.table = this.createTable();
        this.setCellHorizontalAlignment((Widget)this.messageContainer, HasHorizontalAlignment.ALIGN_RIGHT);
        this.buttonContainer.setStyleName("table-panel");
        this.busyIndicator = new BusyIndicator();
        this.busyIndicator.center();
        this.rulesService.getRuleSetsByPackage(packages.toString(), (AsyncCallback<List<UIRuleListItem>>)this.getDataRetrieveCallback());
        this.add((Widget)this.messageContainer);
        this.add((Widget)this.table);
        this.add((Widget)this.buttonContainer);
    }

    private OrderableTable createTable() {
        OrderableTable tbl = new OrderableTable("id");
        tbl.addColumn(this.constants.ruleListViewRuleSetId(), "id");
        tbl.addColumn(this.constants.ruleListViewRuleSetName(), "name");
        this.createAndAddButtons();
        return tbl;
    }

    private void createAndAddButtons() {
        String style = "action-button";
        String lossStyle = "dataloss-button";
        ClickHandler deleteClick = new ClickHandler(){

            public void onClick(ClickEvent event) {
                RulesListingPanel.this.deleteIds();
            }
        };
        ClickHandler createClick = new ClickHandler(){

            public void onClick(ClickEvent event) {
                RulePanel rulePanel = RulePanelFactory.create(RulesListingPanel.this.pkgType);
                rulePanel.setRule(new UIRuleSet());
                RulesComponent.getInstance().setContents(RulesListingPanel.this.pkgType, (Panel)rulePanel);
            }
        };
        ClickHandler createSave = new ClickHandler(){

            public void onClick(ClickEvent event) {
                RulesListingPanel.this.saveListOrder();
            }
        };
        NeptuneSecurity security = RulesComponent.getInstance().getSecurity();
        if (security.isUserInRole(Permissions.MODIFY)) {
            this.addButton(this.constants.save(), style, createSave);
        }
        if (security.isUserInRole(Permissions.CREATE)) {
            this.addButton(this.constants.createRuleSetButtonLabel(), style, createClick);
        }
        if (security.isUserInRole(Permissions.DELETE)) {
            this.addButton(this.constants.delete(), lossStyle, deleteClick);
        }
    }

    private void addButton(String title, String style, ClickHandler click) {
        ButtonWidget button = new ButtonWidget(title, click);
        button.addStyleDependentName(style);
        this.buttonContainer.add((Widget)button);
    }

    private NeptuneAsyncCallback<Object> getSaveOrderCallback() {
        return new NeptuneAsyncCallback<Object>(){

            public void onNeptuneFailure(Throwable caught) {
                RulesListingPanel.this.messageContainer.addErrorMessage("Unable to save error", true);
            }

            public void onNeptuneSuccess(Object o) {
                RulesListingPanel.this.messageContainer.addMessage("Order Saved", true);
            }
        };
    }

    private NeptuneAsyncCallback<List<UIRuleSet>> getDeleteCallback() {
        return new NeptuneAsyncCallback<List<UIRuleSet>>(){

            public void onNeptuneFailure(Throwable caught) {
                if (caught instanceof RuleServiceException) {
                    List<String> msgs = ErrorMessageBuilder.getErrorMessages((RuleServiceException)((Object)caught));
                    RulesListingPanel.this.messageContainer.addErrorMessages(msgs, true);
                } else {
                    RulesListingPanel.this.messageContainer.addErrorMessage("Error Deleting", true);
                }
            }

            public void onNeptuneSuccess(List<UIRuleSet> result) {
                RulesListingPanel.this.messageContainer.clear();
                RulesListingPanel.this.table.clear();
                RulesListingPanel.this.rulesService.getRuleSetsByPackage(RulesListingPanel.this.pkgType.toString(), (AsyncCallback<List<UIRuleListItem>>)RulesListingPanel.this.getDataRetrieveCallback());
            }
        };
    }

    private NeptuneAsyncCallback<List<UIRuleListItem>> getDataRetrieveCallback() {
        return new NeptuneAsyncCallback<List<UIRuleListItem>>(){

            public void onNeptuneFailure(Throwable caught) {
                RulesListingPanel.this.messageContainer.addErrorMessage("Data could not be retrieved", true);
                RulesListingPanel.this.busyIndicator.hide();
            }

            public void onNeptuneSuccess(List<UIRuleListItem> result) {
                int i = 0;
                while (i < result.size()) {
                    UIRuleListItem item = result.get(i);
                    try {
                        HTMLWidget id = new HTMLWidget("" + item.getId());
                        HTMLWidget name = new HTMLWidget(item.getName());
                        id.addClickHandler(RulesListingPanel.this.getDetailHandler(item.getId()));
                        name.addClickHandler(RulesListingPanel.this.getDetailHandler(item.getId()));
                        RulesListingPanel.this.table.addItem(i, "id", id);
                        RulesListingPanel.this.table.addItem(i, "name", name);
                    }
                    catch (RulesUiException e) {
                        String msg = "Error populating table: ";
                        RulesListingPanel.this.messageContainer.addErrorMessage(String.valueOf(msg) + e.getMessage(), true);
                    }
                    ++i;
                }
                RulesListingPanel.this.busyIndicator.hide();
            }
        };
    }

    private ClickHandler getDetailHandler(final int ruleSetId) {
        return new ClickHandler(){

            public void onClick(ClickEvent event) {
                RulesListingPanel.this.busyIndicator.center();
                RulesListingPanel.this.rulesService.getRuleSet(ruleSetId, (AsyncCallback<UIRuleSet>)RulesListingPanel.this.getRulesFetchCallback());
            }
        };
    }

    protected void onUnload() {
        super.onUnload();
        this.busyIndicator.hide();
    }

    private AsyncCallback<UIRuleSet> getRulesFetchCallback() {
        return new AsyncCallback<UIRuleSet>(){

            public void onFailure(Throwable caught) {
                RulesListingPanel.this.messageContainer.addErrorMessage("Error Loading Ruleset", true);
            }

            public void onSuccess(UIRuleSet result) {
                RulePanel rulePanel = RulePanelFactory.create(RulesListingPanel.this.pkgType);
                RulesListingPanel.this.busyIndicator.hide();
                rulePanel.setRule(result);
                RulesComponent.getInstance().setContents(RulesListingPanel.this.pkgType, (Panel)rulePanel);
            }
        };
    }

    private void saveListOrder() {
        Iterator<TableRow> rows = this.table.rowIterator();
        ArrayList<UIRuleListItem> list = new ArrayList<UIRuleListItem>();
        int order = 0;
        while (rows.hasNext()) {
            TableRow row = rows.next();
            UIRuleListItem item = new UIRuleListItem();
            item.setId(Integer.parseInt(row.getValue("id")));
            item.setOrder(order++);
            item.setName(row.getValue("name"));
            list.add(item);
        }
        this.messageContainer.addMessage("Saving order...", true);
        this.rulesService.saveRuleSetOrder(this.pkgType.name(), (List<UIRuleListItem>)list, (AsyncCallback<?>)this.getSaveOrderCallback());
        this.table.resetDirty();
    }

    private void deleteIds() {
        final List<Integer> ids = this.table.getSelectedIds();
        if (ids.size() > 0) {
            String msg = "Are you sure you want to delete?";
            RulesConfirmation.show(msg, new ConfirmationHandler(){

                @Override
                public void confirm(ConfirmationEvent event) {
                    if (event.isConfirm()) {
                        RulesListingPanel.this.messageContainer.addMessage("Deleting...", true);
                        RulesListingPanel.this.rulesService.deleteRuleSet(ids, (AsyncCallback<?>)RulesListingPanel.this.getDeleteCallback());
                    }
                }
            });
        } else {
            this.messageContainer.addErrorMessage("No rules selected!", true);
        }
    }

    public void anchorChanged(String anchor) {
    }
}

