/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.rules.ui.client.contentprocessing;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.CellPanel;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.rules.ui.client.RulesComponent;
import com.tandbergtv.cms.rules.ui.client.UiActionService;
import com.tandbergtv.cms.rules.ui.client.UiActionServiceAsync;
import com.tandbergtv.cms.rules.ui.client.UiRulesTemplateFetcher;
import com.tandbergtv.cms.rules.ui.client.UiRulesTemplateFetcherAsync;
import com.tandbergtv.cms.rules.ui.client.common.EventSelectPanel;
import com.tandbergtv.cms.rules.ui.client.common.MessageContainer;
import com.tandbergtv.cms.rules.ui.client.common.RuleButtonPanel;
import com.tandbergtv.cms.rules.ui.client.common.RuleNamePanel;
import com.tandbergtv.cms.rules.ui.client.common.RulePanel;
import com.tandbergtv.cms.rules.ui.client.common.TitleFilterPanel;
import com.tandbergtv.cms.rules.ui.client.common.WizardPane;
import com.tandbergtv.cms.rules.ui.client.common.WizardPanel;
import com.tandbergtv.cms.rules.ui.client.common.rulelisting.RulesListingPanel;
import com.tandbergtv.cms.rules.ui.client.contentprocessing.ProcessingRulePanel;
import com.tandbergtv.cms.rules.ui.client.contentprocessing.UiWorkflowTemplate;
import com.tandbergtv.cms.rules.ui.client.data.Packages;
import com.tandbergtv.cms.rules.ui.client.data.UIAction;
import com.tandbergtv.cms.rules.ui.client.data.UIRuleSet;
import com.tandbergtv.cms.rules.ui.client.ruleServiceErrorHandling.ErrorMessageBuilder;
import com.tandbergtv.cms.rules.ui.client.ruleServiceErrorHandling.RuleServiceException;
import com.tandbergtv.cms.rules.ui.client.validation.RulePanelHelper;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import java.util.List;

public class ContentProcessingRuleSetPanel
extends RulePanel {
    private RuleNamePanel ruleNamePanel;
    private TitleFilterPanel panelTitleFilter;
    private ProcessingRulePanel processingPanel;
    private EventSelectPanel panelEventSelect;
    private WizardPanel panelWizard = new WizardPanel();
    private BusyIndicator busyIndicator = new BusyIndicator();
    private MessageContainer messageContainer = new MessageContainer();

    public ContentProcessingRuleSetPanel() {
        super(Packages.PROCESSING);
    }

    @Override
    protected void createPanel() {
        this.busyIndicator.center();
        if (!ProcessingRulePanel.cachedLoaded()) {
            this.getAvailableActions();
            this.getAvailableTemplates();
        } else {
            this.populateUi();
        }
    }

    private void populateUi() {
        this.setStyleName("rule-panel");
        this.setHeaderLabel();
        this.messageContainer.clear();
        this.add((Widget)this.messageContainer);
        this.ruleNamePanel = new RuleNamePanel(this.ruleSet.getName(), this.ruleSet.isEnabled());
        RuleButtonPanel panelButton = new RuleButtonPanel(this.ruleSet.isNew());
        panelButton.setSaveClickHandler(this.getSaveHandler());
        panelButton.setCancelClickHandler(this.getDefaultCancelHandler());
        this.panelEventSelect = new EventSelectPanel(this.ruleSet);
        this.panelTitleFilter = new TitleFilterPanel(this.ruleSet);
        this.processingPanel = new ProcessingRulePanel(this.ruleSet.getRules());
        WizardPane collapseRuleName = new WizardPane((CellPanel)this.ruleNamePanel, this.myConstants.wizardRuleName());
        WizardPane collapseEventSelect = new WizardPane((CellPanel)this.panelEventSelect, this.myConstants.wizardEventSelection());
        WizardPane collapseTitleFilter = new WizardPane((CellPanel)this.panelTitleFilter, this.myConstants.wizardTitleFilter());
        WizardPane collapseProcessingRules = new WizardPane((CellPanel)this.processingPanel, this.myConstants.wizardProcessing());
        WizardPane collapseButton = new WizardPane((CellPanel)panelButton);
        this.panelWizard.clear();
        this.panelWizard.addStepPanel(this.myConstants.validationStep1(), collapseEventSelect);
        this.panelWizard.addStepPanel(this.myConstants.validationStep2(), collapseTitleFilter);
        this.panelWizard.addStepPanel(this.myConstants.processingStep3(), collapseProcessingRules);
        this.panelWizard.addStepPanel(this.myConstants.validationStep0(), collapseRuleName);
        this.panelWizard.addStepPanel(this.myConstants.validationStep4(), collapseButton);
        this.add((Widget)this.panelWizard);
        this.panelWizard.show(this.ruleSet.isNew());
        this.busyIndicator.hide();
    }

    private ClickHandler getSaveHandler() {
        return new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (!ContentProcessingRuleSetPanel.this.panelWizard.validateAllItems()) {
                    return;
                }
                final ButtonWidget button = (ButtonWidget)event.getSource();
                UIRuleSet ruleset = new UIRuleSet();
                ruleset.setId(ContentProcessingRuleSetPanel.this.ruleSet.getId());
                ruleset.setEnabled(ContentProcessingRuleSetPanel.this.ruleNamePanel.isEnabled());
                ruleset.setName(ContentProcessingRuleSetPanel.this.ruleNamePanel.getRuleName());
                ruleset.setPackageId(Packages.PROCESSING);
                ruleset.setEvents(ContentProcessingRuleSetPanel.this.panelEventSelect.getEvents());
                ruleset.setRules(ContentProcessingRuleSetPanel.this.processingPanel.getRules());
                ruleset.setTitleFilter(RulePanelHelper.getTitleFilterPanel(ContentProcessingRuleSetPanel.this.panelTitleFilter));
                button.setEnabled(false);
                ContentProcessingRuleSetPanel.this.rulesService.saveRuleSet(ruleset, (AsyncCallback<Integer>)new NeptuneAsyncCallback<Integer>(){

                    public void onNeptuneFailure(Throwable caught) {
                        button.setEnabled(true);
                        if (caught instanceof RuleServiceException) {
                            List<String> messages = ErrorMessageBuilder.getErrorMessages((RuleServiceException)((Object)caught));
                            ContentProcessingRuleSetPanel.this.messageContainer.addErrorMessages(messages, true);
                        } else {
                            Window.alert((String)(caught == null ? "" : caught.getMessage()));
                        }
                    }

                    public void onNeptuneSuccess(Integer result) {
                        ContentProcessingRuleSetPanel.this.messageContainer.clear();
                        button.setEnabled(true);
                        RulesListingPanel listing = new RulesListingPanel(ContentProcessingRuleSetPanel.this.getPackageType());
                        RulesComponent.getInstance().setContents(ContentProcessingRuleSetPanel.this.getPackageType(), (Panel)listing);
                    }
                });
            }
        };
    }

    private void setHeaderLabel() {
        String newRule = this.myConstants.newContentProcessingRule();
        String oldRule = String.valueOf(this.myConstants.contentProcessingRuleDetails()) + " " + this.ruleSet.getName();
        String headerString = this.ruleSet.getName().equals("") ? newRule : oldRule;
        this.setHeaderLabel(headerString);
    }

    private void notifyDoneWithAsync() {
        if (ProcessingRulePanel.cachedLoaded()) {
            this.populateUi();
        }
    }

    private void getAvailableActions() {
        UiActionServiceAsync actionService = (UiActionServiceAsync)GWT.create(UiActionService.class);
        actionService.getActions(Packages.PROCESSING, (AsyncCallback<List<UIAction>>)new NeptuneAsyncCallback<List<UIAction>>(){

            public void onNeptuneFailure(Throwable caught) {
                ContentProcessingRuleSetPanel.this.busyIndicator.hide();
                Window.alert((String)(caught == null ? "" : caught.getMessage()));
            }

            public void onNeptuneSuccess(List<UIAction> result) {
                if (result != null && result.size() == 1) {
                    ProcessingRulePanel.setCachedBlankAction(result.get(0));
                    ContentProcessingRuleSetPanel.this.notifyDoneWithAsync();
                } else {
                    Window.alert((String)"ERROR: There should only be one action available for Content Processing.");
                    ContentProcessingRuleSetPanel.this.busyIndicator.hide();
                }
            }
        });
    }

    private void getAvailableTemplates() {
        UiRulesTemplateFetcherAsync templateFetcherService = (UiRulesTemplateFetcherAsync)GWT.create(UiRulesTemplateFetcher.class);
        templateFetcherService.getTemplates((AsyncCallback<List<UiWorkflowTemplate>>)new NeptuneAsyncCallback<List<UiWorkflowTemplate>>(){

            public void onNeptuneFailure(Throwable caught) {
                ContentProcessingRuleSetPanel.this.busyIndicator.hide();
                Window.alert((String)(caught == null ? "" : caught.getMessage()));
            }

            public void onNeptuneSuccess(List<UiWorkflowTemplate> result) {
                ProcessingRulePanel.setCachedAvailableTemplates(result);
                ContentProcessingRuleSetPanel.this.notifyDoneWithAsync();
            }
        });
    }

    protected void onUnload() {
        super.onUnload();
        this.busyIndicator.hide();
    }
}

