/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.rules.ui.client.data;

import com.google.gwt.user.client.rpc.IsSerializable;
import com.tandbergtv.cms.portal.ui.title.client.criteria.UIGenericType;
import com.tandbergtv.cms.portal.ui.title.client.model.datatype.UIFieldDataType;
import com.tandbergtv.cms.rules.ui.client.data.ActionParams;
import com.tandbergtv.cms.rules.ui.client.data.UIActionParam;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UIAction
implements IsSerializable,
Comparable<UIAction> {
    public static final String VALIDATION_WARN = "com.tandbergtv.marvin.actions.ValidationActions.raiseWarning(String)";
    public static final String VALIDATION_FAIL = "com.tandbergtv.marvin.actions.ValidationActions.raiseError(String)";
    private String action;
    private String labelKey;
    private String[] xpathFilter;
    private int actionId = -1;
    private Map<String, UIActionParam> paramMap = new HashMap<String, UIActionParam>();
    private List<UIActionParam> params = new ArrayList<UIActionParam>();
    private Map<String, UIFieldDataType> valueTypeMap;

    public UIAction() {
    }

    public UIAction(String action) {
        this.action = action;
    }

    public UIAction(String action, int actionId) {
        this.action = action;
        this.actionId = actionId;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public void setActionId(int actionId) {
        this.actionId = actionId;
    }

    public int getActionId() {
        return this.actionId;
    }

    public void addParam(String name, String labelName, UIGenericType value, boolean isLiteral, String type) {
        UIActionParam param = new UIActionParam(name, labelName, value, isLiteral, type);
        this.paramMap.put(name, param);
        this.params.add(param);
    }

    public void addParam(String name, UIGenericType value, boolean isLiteral) {
        UIActionParam param = new UIActionParam(name, value, isLiteral);
        this.paramMap.put(name, param);
        this.params.add(param);
    }

    public UIActionParam getParam(ActionParams paramName) {
        return this.paramMap.get(paramName.getName());
    }

    public List<UIActionParam> getAllParams() {
        return this.params;
    }

    public boolean containsParam(ActionParams paramName) {
        return this.paramMap.containsKey(paramName.getName());
    }

    public void SetParamValue(ActionParams paramName, UIGenericType value) {
        if (this.containsParam(paramName)) {
            this.paramMap.get((Object)paramName).setValue(value);
        }
    }

    public void setLabelKey(String labelKey) {
        this.labelKey = labelKey;
    }

    public String getLabelKey() {
        return this.labelKey;
    }

    public boolean allowsXpath(String xpath) {
        if (this.xpathFilter == null || this.xpathFilter.length == 0) {
            return true;
        }
        int i = 0;
        while (i < this.xpathFilter.length) {
            if (this.xpathFilter[i].equals(xpath)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj instanceof UIAction) {
            String otherAction = ((UIAction)obj).action;
            return this.action.equals(otherAction);
        }
        return false;
    }

    public UIAction clone() {
        UIAction result = new UIAction();
        result.action = this.action;
        result.actionId = this.actionId;
        result.labelKey = this.labelKey;
        result.valueTypeMap = this.valueTypeMap;
        result.paramMap = new HashMap<String, UIActionParam>();
        result.params = new ArrayList<UIActionParam>();
        for (UIActionParam param : this.params) {
            UIActionParam newParam = param.clone();
            result.paramMap.put(param.getName(), newParam);
            result.params.add(newParam);
        }
        if (this.xpathFilter != null) {
            result.xpathFilter = new String[this.xpathFilter.length];
            int i = 0;
            while (i < this.xpathFilter.length) {
                result.xpathFilter[i] = this.xpathFilter[i];
                ++i;
            }
        }
        return result;
    }

    public void setValueTypeMap(Map<String, UIFieldDataType> valueTypeMap) {
        this.valueTypeMap = valueTypeMap;
    }

    public Map<String, UIFieldDataType> getValueTypeMap() {
        return this.valueTypeMap;
    }

    public void setXpathFilter(String[] xpathFilter) {
        this.xpathFilter = xpathFilter;
    }

    public String[] getXpathFilter() {
        return this.xpathFilter;
    }

    @Override
    public int compareTo(UIAction uiAction) {
        return this.labelKey.compareToIgnoreCase(uiAction.labelKey);
    }
}

