/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.rules.ui.server;

import com.tandbergtv.cms.portal.ui.title.client.criteria.UIGenericType;
import com.tandbergtv.cms.portal.ui.title.client.model.datatype.BooleanDataType;
import com.tandbergtv.cms.portal.ui.title.client.model.datatype.DateDataType;
import com.tandbergtv.cms.portal.ui.title.client.model.datatype.FloatDataType;
import com.tandbergtv.cms.portal.ui.title.client.model.datatype.IntegerDataType;
import com.tandbergtv.cms.portal.ui.title.client.model.datatype.TimeDataType;
import com.tandbergtv.cms.portal.ui.title.client.model.datatype.UIFieldDataType;
import com.tandbergtv.cms.portal.ui.title.client.model.search.IUITitleFilterNode;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilterListNode;
import com.tandbergtv.cms.portal.ui.title.server.search.TitleFilterServiceError;
import com.tandbergtv.cms.portal.ui.title.server.search.UiTitleFilterService;
import com.tandbergtv.cms.portal.ui.title.server.search.UiTitleFilterServiceImpl;
import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.cms.rules.service.IRuleService;
import com.tandbergtv.cms.rules.service.RuleDeleteException;
import com.tandbergtv.cms.rules.service.RuleSaveException;
import com.tandbergtv.cms.rules.service.RuleServiceStatus;
import com.tandbergtv.cms.rules.service.category.EventRetrivalException;
import com.tandbergtv.cms.rules.service.category.IEventManager;
import com.tandbergtv.cms.rules.service.category.IPackageManager;
import com.tandbergtv.cms.rules.service.category.IRuleManager;
import com.tandbergtv.cms.rules.service.category.PackageRetrievalException;
import com.tandbergtv.cms.rules.ui.client.UiRulesService;
import com.tandbergtv.cms.rules.ui.client.data.Packages;
import com.tandbergtv.cms.rules.ui.client.data.UIAction;
import com.tandbergtv.cms.rules.ui.client.data.UIActionParam;
import com.tandbergtv.cms.rules.ui.client.data.UIEvent;
import com.tandbergtv.cms.rules.ui.client.data.UIEventType;
import com.tandbergtv.cms.rules.ui.client.data.UIRule;
import com.tandbergtv.cms.rules.ui.client.data.UIRuleListItem;
import com.tandbergtv.cms.rules.ui.client.data.UIRuleSet;
import com.tandbergtv.cms.rules.ui.client.ruleServiceErrorHandling.RuleServiceException;
import com.tandbergtv.cms.rules.ui.client.ruleServiceErrorHandling.UIRuleServiceErrorMessage;
import com.tandbergtv.cms.rules.ui.server.RulePersistenceException;
import com.tandbergtv.marvin.udt.GenericType;
import com.tandbergtv.marvin.udt.TreAction;
import com.tandbergtv.marvin.udt.TreActionParameterValue;
import com.tandbergtv.marvin.udt.TreEvent;
import com.tandbergtv.marvin.udt.TrePackage;
import com.tandbergtv.marvin.udt.TreRule;
import com.tandbergtv.marvin.udt.TreRuleSet;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;
import com.tandbergtv.neptune.widgettoolkit.server.remote.NeptuneRemoteService;
import com.tandbergtv.watchpoint.pmm.entities.titlefilter.TreTitleFilter;
import com.tandbergtv.workflow.comm.routing.IRoutingService;
import com.tandbergtv.workflow.comm.routing.RoutingServiceFactory;
import com.tandbergtv.workflow.message.IMessage;
import com.tandbergtv.workflow.message.IPayload;
import com.tandbergtv.workflow.message.MessageImpl;
import com.tandbergtv.workflow.message.StringPayload;
import com.tandbergtv.workflow.message.WPCLCommand;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.WorkflowMessageFactory;
import com.tandbergtv.workflow.message.util.Marshaller;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.aspectj.runtime.internal.AroundClosure;
import org.w3c.dom.Document;

public class UiRulesServiceImpl
implements UiRulesService,
NeptuneRemoteService {
    private static final Logger logger = Logger.getLogger(UiRulesServiceImpl.class);
    private static final String COMMAND_NAME = "create";
    private static final String UID = "re0101";
    private IRuleManager ruleManager = (IRuleManager)InjectionUtil.injectInstance((String)"cms/RuleManagerImpl/local", IRuleManager.class);
    private IEventManager eventManager = (IEventManager)InjectionUtil.injectInstance((String)"cms/EventManagerImpl/local", IEventManager.class);
    private IPackageManager packageManager = (IPackageManager)InjectionUtil.injectInstance((String)"cms/PackageManagerImpl/local", IPackageManager.class);
    private UiTitleFilterService titleFilterService = new UiTitleFilterServiceImpl();

    @Override
    @Transactional
    public List<UIRuleListItem> getRuleSetsByPackage(String packageName) throws NeptuneException {
        String string = packageName;
        return (List)UiRulesServiceImpl.getRuleSetsByPackage_aroundBody1$advice(this, string, TransactionEnforcer.aspectOf(), UiRulesServiceImpl.class.getDeclaredMethod("getRuleSetsByPackage", String.class).getAnnotation(Transactional.class), null);
    }

    @Override
    @Transactional
    public void saveRuleSetOrder(String pkgName, List<UIRuleListItem> list) throws NeptuneException {
        String string = pkgName;
        List<UIRuleListItem> list2 = list;
        UiRulesServiceImpl.saveRuleSetOrder_aroundBody3$advice(this, string, list2, TransactionEnforcer.aspectOf(), UiRulesServiceImpl.class.getDeclaredMethod("saveRuleSetOrder", String.class, List.class).getAnnotation(Transactional.class), null);
    }

    private TreRuleSet getByID(List<TreRuleSet> list, int id) {
        for (TreRuleSet item : list) {
            if (item.getRuleSetId() != id) continue;
            return item;
        }
        return null;
    }

    @Override
    @Transactional
    public UIRuleSet getRuleSet(int ruleSetId) throws NeptuneException {
        int n = ruleSetId;
        return (UIRuleSet)UiRulesServiceImpl.getRuleSet_aroundBody5$advice(this, n, TransactionEnforcer.aspectOf(), UiRulesServiceImpl.class.getDeclaredMethod("getRuleSet", Integer.TYPE).getAnnotation(Transactional.class), null);
    }

    private UIRuleSet convertRuleSetToUIRuleSet(TreRuleSet rs, String packageName) throws TitleFilterServiceError {
        UIRuleSet result = new UIRuleSet();
        if (rs.getRuleSetId() != null) {
            result.setId(rs.getRuleSetId());
            result.setVersion(rs.getVersion());
        }
        result.setName(rs.getRuleName());
        result.setEnabled(rs.getEnabled());
        result.setPackageId(Packages.lookup(packageName));
        if (rs.getFilter() != null) {
            result.setTitleFilter(this.titleFilterService.convertTitleFilter(rs.getFilter()));
        }
        result.setLastModifiedBy("Kinjal Mehta");
        result.setLastModifiedDate("1/1/1900");
        for (TreEvent e : rs.getEvents()) {
            result.addEvent(new UIEvent(e.getName(), true));
        }
        if (rs.getRules() != null) {
            for (TreRule r : rs.getRules()) {
                UIRule uiRule = new UIRule();
                if (r.getRuleId() != null) {
                    uiRule.setId(r.getRuleId());
                }
                if (r.getVersion() != null) {
                    uiRule.setVersion(r.getVersion());
                }
                if (r.getConditions() != null) {
                    uiRule.setUiTitleFilterNode((IUITitleFilterNode)((UITitleFilterListNode)this.titleFilterService.convertExpNode(r.getConditions())));
                }
                uiRule.setActions(this.convertActions(r));
                result.addRule(uiRule);
            }
        }
        return result;
    }

    @Override
    public int saveRuleSet(UIRuleSet ruleSet) throws NeptuneException {
        try {
            this.checkEvents(ruleSet);
        }
        catch (RuleSaveException e) {
            throw new RuleServiceException(this.convertErrorMessage(e.getReasons()));
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuleSaveException) {
                List<UIRuleServiceErrorMessage> reasons = this.convertErrorMessage(((RuleSaveException)cause).getReasons());
                throw new RuleServiceException(reasons);
            }
            throw e;
        }
        TreRuleSet result = this.convertUIRuleSetToRuleSet(ruleSet);
        return result.getRuleSetId();
    }

    private List<UIRuleServiceErrorMessage> convertErrorMessage(List<RuleServiceStatus> reasons) {
        ArrayList<UIRuleServiceErrorMessage> result = new ArrayList<UIRuleServiceErrorMessage>();
        for (RuleServiceStatus r : reasons) {
            result.add(new UIRuleServiceErrorMessage(r.getErrorCode(), r.getParameters()));
        }
        return result;
    }

    private List<UIAction> convertActions(TreRule rule) {
        ArrayList<UIAction> uiActions = new ArrayList<UIAction>();
        for (TreAction taction : rule.getActions()) {
            UIAction uiAction = new UIAction(taction.getMethod(), taction.getActionId());
            uiActions.add(uiAction);
            for (TreActionParameterValue param : taction.getParams()) {
                Object paramVal = param.getValueAsObject();
                UIGenericType paramValue = null;
                if (paramVal != null) {
                    paramValue = new UIGenericType();
                    if (paramVal instanceof String) {
                        paramValue.setStringValue((String)paramVal);
                    } else if (paramVal instanceof Boolean) {
                        paramValue.setBooleanValue((Boolean)paramVal);
                    } else if (paramVal instanceof GenericType) {
                        GenericType paramValGenericType = (GenericType)paramVal;
                        if (paramValGenericType.getDataType() == GenericType.DataTypes.STRING) {
                            paramValue.setStringValue(paramValGenericType.getStringValue());
                        } else if (paramValGenericType.getDataType() == GenericType.DataTypes.LONG) {
                            paramValue.setLongValue(Long.valueOf(paramValGenericType.getLongValue()));
                        } else if (paramValGenericType.getDataType() == GenericType.DataTypes.FLOAT) {
                            paramValue.setFloatValue(Float.valueOf(paramValGenericType.getFloatValue()));
                        } else if (paramValGenericType.getDataType() == GenericType.DataTypes.BOOLEAN) {
                            paramValue.setBooleanValue(Boolean.valueOf(paramValGenericType.getBooleanValue()));
                        } else if (paramValGenericType.getDataType() == GenericType.DataTypes.TIME) {
                            paramValue.setTimeValue(paramValGenericType.getTimeValue());
                        } else if (paramValGenericType.getDataType() == GenericType.DataTypes.DATE) {
                            paramValue.setDateValue(paramValGenericType.getDateValue());
                        }
                    }
                }
                uiAction.addParam(param.getName(), paramValue, param.getIsLiteral());
            }
        }
        return uiActions;
    }

    private void checkEvents(UIRuleSet uiRuleSet) throws RuleSaveException {
        if (uiRuleSet.isNew() || uiRuleSet.getPackageId().equals((Object)Packages.VALIDATION)) {
            return;
        }
        boolean containsSechedulable = false;
        for (UIEvent uiEvent : uiRuleSet.getEvents()) {
            if (uiEvent.getEventType() != UIEventType.SCHEDULE) continue;
            containsSechedulable = true;
        }
        if (!containsSechedulable) {
            ServiceLoader<IRuleService> services = ServiceLoader.load(IRuleService.class);
            ArrayList<RuleServiceStatus> reasons = new ArrayList<RuleServiceStatus>();
            for (IRuleService service : services) {
                int rsId;
                RuleServiceStatus serviceStatus = service.canRemoveSchedulable((long)(rsId = uiRuleSet.getId()));
                if (serviceStatus.canProceed()) continue;
                reasons.add(serviceStatus);
            }
            if (reasons.size() > 0) {
                throw new RuleSaveException(reasons);
            }
        }
    }

    public String getRelativePath() {
        return "service/rules/uiRulesService";
    }

    @Transactional
    private TreRuleSet convertUIRuleSetToRuleSet(UIRuleSet rs) throws NeptuneException {
        UIRuleSet uIRuleSet = rs;
        return (TreRuleSet)UiRulesServiceImpl.convertUIRuleSetToRuleSet_aroundBody7$advice(this, uIRuleSet, TransactionEnforcer.aspectOf(), UiRulesServiceImpl.class.getDeclaredMethod("convertUIRuleSetToRuleSet", UIRuleSet.class).getAnnotation(Transactional.class), null);
    }

    private void handleRules(UIRuleSet rs, TreRuleSet result) {
        if (result.getRules() != null && result.getRules().size() > 0) {
            this.updateRules(rs, result);
        } else {
            this.createRules(rs, result);
        }
    }

    private void updateRules(UIRuleSet rs, TreRuleSet result) {
        Iterator deleteIterator = result.getRules().iterator();
        while (deleteIterator.hasNext()) {
            TreRule trule = (TreRule)deleteIterator.next();
            boolean found = false;
            for (UIRule r : rs.getRules()) {
                if (r.getId() != trule.getRuleId().intValue()) continue;
                found = true;
                break;
            }
            if (found) continue;
            deleteIterator.remove();
        }
        List<UIRule> uirules = rs.getRules();
        int uiruleIndex = 0;
        while (uiruleIndex < uirules.size()) {
            UIRule uirule = uirules.get(uiruleIndex);
            boolean found = false;
            List resultRules = result.getRules();
            int truleIndex = 0;
            while (truleIndex < resultRules.size()) {
                TreRule trule = (TreRule)resultRules.get(truleIndex);
                if (trule.getRuleId() != null && uirule.getId() == trule.getRuleId().intValue()) {
                    this.convertRule(trule, uirule);
                    found = true;
                    if (truleIndex < uiruleIndex) {
                        resultRules.remove(truleIndex);
                        resultRules.add(uiruleIndex - 1, trule);
                        break;
                    }
                    if (truleIndex <= uiruleIndex) break;
                    resultRules.remove(truleIndex);
                    resultRules.add(uiruleIndex, trule);
                    break;
                }
                ++truleIndex;
            }
            if (!found) {
                TreRule trule = new TreRule();
                this.convertRule(trule, uirule);
                resultRules.add(uiruleIndex, trule);
            }
            ++uiruleIndex;
        }
    }

    private void createRules(UIRuleSet rs, TreRuleSet result) {
        ArrayList<TreRule> rules = result.getRules();
        if (rules == null) {
            rules = new ArrayList<TreRule>();
        }
        for (UIRule r : rs.getRules()) {
            TreRule trule = new TreRule();
            this.convertRule(trule, r);
            rules.add(trule);
        }
        if (rules.size() > 0) {
            result.setRules(rules);
        }
    }

    private void convertRule(TreRule trule, UIRule uiRule) {
        ArrayList<TreAction> treActions;
        if (uiRule.getUiTitleFilterNode() != null) {
            trule.setConditions(this.titleFilterService.convertTree(trule.getConditions(), uiRule.getUiTitleFilterNode()));
        }
        if ((treActions = trule.getActions()) == null) {
            treActions = new ArrayList<TreAction>();
            trule.setActions(treActions);
        }
        List<UIAction> uiActions = uiRule.getActions();
        int i = 0;
        while (i < uiActions.size()) {
            if (i >= treActions.size()) {
                treActions.add(new TreAction());
            }
            TreAction currAction = (TreAction)treActions.get(i);
            currAction.setMethod(uiActions.get(i).getAction());
            ArrayList<TreActionParameterValue> treparams = currAction.getParams();
            if (treparams == null) {
                treparams = new ArrayList<TreActionParameterValue>();
                currAction.setParams(treparams);
            }
            List<UIActionParam> uiparams = uiActions.get(i).getAllParams();
            int j = 0;
            while (j < uiparams.size()) {
                UIActionParam currUIParam = uiparams.get(j);
                UIGenericType currUIParamValue = currUIParam.getValue();
                if (j >= treparams.size()) {
                    try {
                        treparams.add(new TreActionParameterValue(currUIParam.getName(), this.convertUiParamValue(currUIParamValue, currUIParam.getDataType()), currUIParam.isLiteral()));
                    }
                    catch (IOException e) {
                        logger.error((Object)"error while adding new action param ", (Throwable)e);
                    }
                } else {
                    ((TreActionParameterValue)treparams.get(j)).setName(currUIParam.getName());
                    try {
                        ((TreActionParameterValue)treparams.get(j)).setValueAsObject(this.convertUiParamValue(currUIParamValue, currUIParam.getDataType()));
                    }
                    catch (IOException e) {
                        logger.error((Object)"error while converting action param ", (Throwable)e);
                    }
                    ((TreActionParameterValue)treparams.get(j)).setIsLiteral(Boolean.valueOf(currUIParam.isLiteral()));
                }
                ++j;
            }
            ArrayList<TreActionParameterValue> tailParamsToRemove = new ArrayList<TreActionParameterValue>();
            int k = uiparams.size();
            while (k < treparams.size()) {
                tailParamsToRemove.add((TreActionParameterValue)treparams.get(k));
                ++k;
            }
            for (TreActionParameterValue param : tailParamsToRemove) {
                treparams.remove(param);
            }
            ++i;
        }
        ArrayList<TreAction> tailActionsToRemove = new ArrayList<TreAction>();
        int i2 = uiActions.size();
        while (i2 < treActions.size()) {
            tailActionsToRemove.add((TreAction)treActions.get(i2));
            ++i2;
        }
        for (TreAction t : tailActionsToRemove) {
            treActions.remove(t);
        }
    }

    private Object convertUiParamValue(UIGenericType value, String dataType) {
        if (dataType.equals("class java.lang.String")) {
            return value.toString();
        }
        if (dataType.equals("class java.lang.Boolean")) {
            return value.getBooleanValue();
        }
        if (dataType.equals("class com.tandbergtv.marvin.udt.GenericType")) {
            GenericType result = new GenericType();
            UIFieldDataType genDataType = value.getDataType();
            if (genDataType instanceof BooleanDataType) {
                result.setBooleanValue(value.getBooleanValue().booleanValue());
            } else if (genDataType instanceof DateDataType) {
                result.setDateValue(value.getDateValue());
            } else if (genDataType instanceof TimeDataType) {
                result.setTimeValue(value.getTimeValue());
            } else if (genDataType instanceof IntegerDataType) {
                result.setLongValue(value.getLongValue().longValue());
            } else if (genDataType instanceof FloatDataType) {
                result.setFloatValue(value.getFloatValue().floatValue());
            } else {
                result.setStringValue(value.getStringValue());
            }
            return result;
        }
        return null;
    }

    private Set<TreEvent> getEvents(UIRuleSet rs) throws EventRetrivalException {
        List<UIEvent> uievents = rs.getEvents();
        HashSet<TreEvent> events = null;
        for (UIEvent e : uievents) {
            if (!e.isEnabled()) continue;
            if (events == null) {
                events = new HashSet<TreEvent>();
            }
            events.add(this.eventManager.getEvent(e.getEventType().toString()));
        }
        return events;
    }

    public Class<?> getServiceImplementation() {
        return this.getClass();
    }

    @Override
    public void deleteRuleSet(List<Integer> ruleSetIds) throws NeptuneException {
        try {
            this.deleteRuleSets(ruleSetIds);
        }
        catch (RuleDeleteException e) {
            throw new RuleServiceException(this.convertErrorMessage(e.getReasons()));
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuleDeleteException) {
                List<UIRuleServiceErrorMessage> reasons = this.convertErrorMessage(((RuleDeleteException)cause).getReasons());
                throw new RuleServiceException(reasons);
            }
            throw e;
        }
    }

    private void deleteRuleSets(List<Integer> ruleSetIds) throws RuleDeleteException {
        this.ruleManager.deleteRuleSets(ruleSetIds);
    }

    @Override
    public void saveAndRunRuleSet(UIRuleSet ruleSet) throws NeptuneException {
        int ruleSetId = this.saveRuleSet(ruleSet);
        logger.info((Object)("Running against all titles the normalization rule with id: " + ruleSetId));
        WorkflowMessage message = WorkflowMessageFactory.createControlMessage((String)UID);
        WPCLCommand command = new WPCLCommand(COMMAND_NAME);
        message.setCommand(command);
        message.getPayload().putValue("ruleSetId", Integer.toString(ruleSetId));
        IRoutingService router = RoutingServiceFactory.newInstance().createRoutingService();
        try {
            router.send(this.getMessage(message));
            logger.info((Object)"Kicked off batch normalization template.");
        }
        catch (Exception e) {
            logger.error((Object)"DUDE, there was an error when kicking off batch normalization template.", (Throwable)e);
        }
    }

    private IMessage getMessage(WorkflowMessage wpcl) throws Exception {
        Document document = Marshaller.newMarshaller().marshal(wpcl);
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        StringWriter writer = new StringWriter();
        transformer.transform(new DOMSource(document.getDocumentElement()), new StreamResult(writer));
        return new MessageImpl((IPayload)new StringPayload(writer.getBuffer().toString()));
    }

    private static final /* synthetic */ List getRuleSetsByPackage_aroundBody0(UiRulesServiceImpl this_, String packageName) {
        ArrayList<UIRuleListItem> result = new ArrayList<UIRuleListItem>();
        try {
            TrePackage pkg = this_.packageManager.getPackageByNameFirstMatching(packageName);
            List rulesets = pkg.getRuleSets();
            for (TreRuleSet r : rulesets) {
                int id = r.getRuleSetId();
                String name = r.getRuleName();
                result.add(new UIRuleListItem(id, name));
            }
        }
        catch (PackageRetrievalException e1) {
            RulePersistenceException ex = new RulePersistenceException();
            ex.setStackTrace(e1.getStackTrace());
            throw ex;
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object getRuleSetsByPackage_aroundBody1$advice(UiRulesServiceImpl this_, String transactional, TransactionEnforcer ajc_aroundClosure, Transactional transactional2, AroundClosure aroundClosure) {
        void e;
        void transactionManager;
        void isTransactionOwner;
        TransactionManager transactionManager2 = null;
        boolean bl = false;
        try {
            transactionManager2 = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            bl = transactionManager2.getTransaction() == null;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        if (!bl) {
            void var9_10 = isTransactionOwner;
            void var10_11 = transactionManager;
            return UiRulesServiceImpl.getRuleSetsByPackage_aroundBody0(this_, transactional);
        }
        try {
            void object;
            e.begin();
            void var11_12 = isTransactionOwner;
            void var12_13 = transactionManager;
            List list = UiRulesServiceImpl.getRuleSetsByPackage_aroundBody0(this_, transactional);
            object.commit();
            return list;
        }
        catch (Exception exception) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)exception);
            try {
                e.rollback();
            }
            catch (Exception exception2) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)exception2);
            }
            throw new RuntimeException(exception);
        }
    }

    private static final /* synthetic */ void saveRuleSetOrder_aroundBody2(UiRulesServiceImpl this_, String pkgName, List list) {
        try {
            TrePackage pkg = this_.packageManager.getPackageByNameFirstMatching(pkgName);
            List rulesets = pkg.getRuleSets();
            for (UIRuleListItem item : list) {
                TreRuleSet ruleset = this_.getByID(rulesets, item.getId());
                if (ruleset == null) continue;
                rulesets.remove(rulesets.indexOf(ruleset));
                rulesets.add(item.getOrder(), ruleset);
            }
        }
        catch (Exception e) {
            RulePersistenceException ex = new RulePersistenceException();
            ex.setStackTrace(e.getStackTrace());
            throw ex;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object saveRuleSetOrder_aroundBody3$advice(UiRulesServiceImpl this_, String transactional, List ajc_aroundClosure, TransactionEnforcer transactionEnforcer, Transactional transactional2, AroundClosure aroundClosure) {
        void isTransactionOwner;
        void e;
        TransactionManager transactionManager = null;
        boolean bl = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            bl = transactionManager.getTransaction() == null;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        if (!bl) {
            void var10_11 = e;
            void var11_12 = isTransactionOwner;
            UiRulesServiceImpl.saveRuleSetOrder_aroundBody2(this_, transactional, ajc_aroundClosure);
            return null;
        }
        try {
            transactionManager.begin();
            void var12_13 = e;
            void var13_14 = isTransactionOwner;
            UiRulesServiceImpl.saveRuleSetOrder_aroundBody2(this_, transactional, ajc_aroundClosure);
            Object var8_9 = null;
            transactionManager.commit();
            return var8_9;
        }
        catch (Exception exception) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)exception);
            try {
                transactionManager.rollback();
            }
            catch (Exception exception2) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)exception2);
            }
            throw new RuntimeException(exception);
        }
    }

    private static final /* synthetic */ UIRuleSet getRuleSet_aroundBody4(UiRulesServiceImpl this_, int ruleSetId) {
        TreRuleSet rs = this_.ruleManager.getRule(ruleSetId);
        return this_.convertRuleSetToUIRuleSet(rs, rs.getTpackage().getName());
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object getRuleSet_aroundBody5$advice(UiRulesServiceImpl this_, int transactional, TransactionEnforcer ajc_aroundClosure, Transactional transactional2, AroundClosure aroundClosure) {
        void e;
        void transactionManager;
        void isTransactionOwner;
        TransactionManager transactionManager2 = null;
        boolean bl = false;
        try {
            transactionManager2 = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            bl = transactionManager2.getTransaction() == null;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        if (!bl) {
            void var9_10 = isTransactionOwner;
            void var10_11 = transactionManager;
            return UiRulesServiceImpl.getRuleSet_aroundBody4(this_, transactional);
        }
        try {
            void object;
            e.begin();
            void var11_12 = isTransactionOwner;
            void var12_13 = transactionManager;
            UIRuleSet uIRuleSet = UiRulesServiceImpl.getRuleSet_aroundBody4(this_, transactional);
            object.commit();
            return uIRuleSet;
        }
        catch (Exception exception) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)exception);
            try {
                e.rollback();
            }
            catch (Exception exception2) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)exception2);
            }
            throw new RuntimeException(exception);
        }
    }

    private static final /* synthetic */ TreRuleSet convertUIRuleSetToRuleSet_aroundBody6(UiRulesServiceImpl this_, UIRuleSet rs) {
        TreRuleSet result = null;
        TrePackage pack = null;
        try {
            pack = this_.packageManager.getPackageByNameFirstMatching(rs.getPackageId().toString());
        }
        catch (PackageRetrievalException e1) {
            RulePersistenceException ex = new RulePersistenceException();
            ex.setStackTrace(e1.getStackTrace());
            throw ex;
        }
        if (rs.isNew()) {
            result = new TreRuleSet();
            pack.getRuleSets().add(result);
        } else {
            boolean found = false;
            Iterator catRuleSets = pack.getRuleSets().iterator();
            while (!found && catRuleSets.hasNext()) {
                TreRuleSet curr = (TreRuleSet)catRuleSets.next();
                if (curr.getRuleSetId().intValue() != rs.getId()) continue;
                found = true;
                result = curr;
            }
        }
        result.setRuleName(rs.getName());
        result.setEnabled(Boolean.valueOf(rs.isEnabled()));
        try {
            result.setEvents(this_.getEvents(rs));
        }
        catch (EventRetrivalException e) {
            throw new RulePersistenceException(e.getStackTrace());
        }
        if (rs.getTitleFilter() != null) {
            if (result.getFilter() == null) {
                result.setFilter(new TreTitleFilter());
            }
            this_.titleFilterService.convertTitleFilter(result.getFilter(), rs.getTitleFilter());
        }
        if (rs.getRules() != null) {
            this_.handleRules(rs, result);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object convertUIRuleSetToRuleSet_aroundBody7$advice(UiRulesServiceImpl this_, UIRuleSet transactional, TransactionEnforcer ajc_aroundClosure, Transactional transactional2, AroundClosure aroundClosure) {
        void e;
        void transactionManager;
        void isTransactionOwner;
        TransactionManager transactionManager2 = null;
        boolean bl = false;
        try {
            transactionManager2 = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            bl = transactionManager2.getTransaction() == null;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        if (!bl) {
            void var9_10 = isTransactionOwner;
            void var10_11 = transactionManager;
            return UiRulesServiceImpl.convertUIRuleSetToRuleSet_aroundBody6(this_, transactional);
        }
        try {
            void object;
            e.begin();
            void var11_12 = isTransactionOwner;
            void var12_13 = transactionManager;
            TreRuleSet treRuleSet = UiRulesServiceImpl.convertUIRuleSetToRuleSet_aroundBody6(this_, transactional);
            object.commit();
            return treRuleSet;
        }
        catch (Exception exception) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)exception);
            try {
                e.rollback();
            }
            catch (Exception exception2) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)exception2);
            }
            throw new RuntimeException(exception);
        }
    }
}

