/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.scheduler;

import com.ericsson.cms.scheduler.IScheduler;
import com.ericsson.cms.scheduler.ScheduleTime;
import com.ericsson.cms.scheduler.SchedulerException;
import com.ericsson.cms.scheduler.conf.SchedulerPropertiesReader;
import com.ericsson.cms.scheduler.entities.FutureExecution;
import com.ericsson.cms.scheduler.entities.Job;
import com.ericsson.cms.scheduler.entities.PastExecution;
import com.ericsson.cms.scheduler.entities.ScheduleRule;
import com.ericsson.cms.scheduler.quartz.IQuartzScheduler;
import com.ericsson.cms.scheduler.quartz.QuartzCallback;
import com.ericsson.cms.scheduler.timers.Daily;
import com.ericsson.cms.scheduler.timers.EveryNDays;
import com.ericsson.cms.scheduler.timers.OnDate;
import com.ericsson.cms.scheduler.timers.OnDayEveryNWeeks;
import com.tandbergtv.watchpoint.pmm.dao.hibernate.HibernateContext;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.naming.InitialContext;
import org.apache.log4j.Logger;
import org.hibernate.Query;
import org.hibernate.Session;

@Stateless
@TransactionAttribute
public class Scheduler
implements IScheduler {
    private static final Logger logger = Logger.getLogger(Scheduler.class);

    public Job get(long id) {
        Job job = (Job)this.getSession().get(Job.class, (Serializable)Long.valueOf(id));
        if (job == null) {
            throw new SchedulerException("No job with id: " + id + " found.");
        }
        return job;
    }

    public List<Job> getAllJobs() {
        String queryStr = "from Job";
        Session session = this.getSession();
        Query query = session.createQuery(queryStr);
        return query.list();
    }

    public List<Job> getAllActiveJobs() {
        String queryStr = "from Job where active = true";
        Session session = this.getSession();
        Query query = session.createQuery(queryStr);
        return query.list();
    }

    public List<Job> getJobsByAssociatedEntityType(String entityType) {
        String queryStr = "from Job where associatedEntityType = :entityType";
        Session session = this.getSession();
        Query query = session.createQuery(queryStr);
        query.setParameter("entityType", (Object)entityType);
        return query.list();
    }

    public List<Job> getJobsByAssociatedEntity(String entityType, long entityId) {
        String queryStr = "from Job where associatedEntityType = :entityType and :entityId in elements(associatedEntities)";
        Session session = this.getSession();
        Query query = session.createQuery(queryStr);
        query.setParameter("entityType", (Object)entityType);
        query.setParameter("entityId", (Object)entityId);
        return query.list();
    }

    public Job schedule(Job job) {
        boolean create;
        boolean bl = create = job.getId() == null;
        if (create) {
            job.setActive(true);
        } else {
            Job dbJob = this.get(job.getId());
            job.setActive(dbJob.isActive());
            this.getSession().evict((Object)dbJob);
        }
        this.getSession().saveOrUpdate((Object)job);
        ScheduleTime time = this.getScheduleTime(job.getRule());
        if (create) {
            this.getQuartzScheduler().schedule(job.getId(), time);
        } else if (job.isActive()) {
            this.getQuartzScheduler().updateSchedule(job.getId(), time);
        }
        return job;
    }

    public void setActive(long id, boolean active) {
        Job job = this.get(id);
        if (job.isActive() == active) {
            throw new SchedulerException("Job is already " + (active ? "active" : "inactive"));
        }
        job.setActive(active);
        this.getSession().saveOrUpdate((Object)job);
        if (active) {
            this.getQuartzScheduler().schedule(id, this.getScheduleTime(job.getRule()));
        } else {
            this.getQuartzScheduler().deleteSchedule(id);
        }
    }

    public void dissociate(long jobId, long entityId) {
        Job job = this.get(jobId);
        boolean found = job.getAssociatedEntities().remove(entityId);
        if (!found) {
            throw new SchedulerException("The Schedule is not associated with the given entity");
        }
        this.getSession().saveOrUpdate((Object)job);
    }

    public void delete(long id) {
        List<PastExecution> associatedPastExecutions;
        Job job = this.get(id);
        if (job.isActive()) {
            this.getQuartzScheduler().deleteSchedule(id);
        }
        if ((associatedPastExecutions = this.getPastExecutions(job.getId())) != null) {
            for (PastExecution pe : associatedPastExecutions) {
                this.getSession().delete((Object)pe);
            }
        }
        this.getSession().delete((Object)job);
    }

    public void runNow(long id) {
        Job job = this.get(id);
        if (!job.isActive()) {
            throw new SchedulerException("Cannot run the job. Job is inactive.");
        }
        logger.info((Object)("Run Now requested for job: " + id));
        new QuartzCallback().execute(Long.toString(id), new Date());
    }

    private List<PastExecution> getPastExecutions(long jobId) {
        String queryStr = "from PastExecution where job.id = :jobId";
        Session session = this.getSession();
        Query query = session.createQuery(queryStr);
        query.setLong("jobId", jobId);
        return query.list();
    }

    public List<PastExecution> getPastExecutions(int numHours) {
        Date afterDate = this.subtract(new Date(), numHours);
        String queryStr = "from PastExecution where executionTime >= :executionTime order by executionTime desc";
        Session session = this.getSession();
        Query query = session.createQuery(queryStr);
        query.setDate("executionTime", afterDate);
        return query.list();
    }

    public List<FutureExecution> getFutureExecutions(int numHours) {
        ArrayList<FutureExecution> executions = new ArrayList<FutureExecution>();
        Date afterDate = new Date();
        List<Job> activeJobs = this.getAllActiveJobs();
        if (activeJobs != null) {
            for (Job job : activeJobs) {
                executions.addAll(this.getFutureExecutions(job, afterDate, numHours));
            }
        }
        Collections.sort(executions, new Comparator<FutureExecution>(){

            @Override
            public int compare(FutureExecution o1, FutureExecution o2) {
                return o1.getExecutionTime().compareTo(o2.getExecutionTime());
            }
        });
        return executions;
    }

    public List<FutureExecution> getNFutureExecutions(int count) {
        List<Object> executions = new ArrayList();
        Map<String, String> schedulerProperties = SchedulerPropertiesReader.getProperties();
        int lookupPeriodDays = SchedulerPropertiesReader.getLookupPeriodDays(schedulerProperties);
        int maxLookups = SchedulerPropertiesReader.getMaxLookups(schedulerProperties);
        int periodHours = 24 * lookupPeriodDays;
        int m = 1;
        while (executions.size() < count && m <= maxLookups) {
            executions = this.getFutureExecutions(periodHours * m++);
            Iterator<Object> eIterator = executions.iterator();
            while (eIterator.hasNext()) {
                FutureExecution execution = (FutureExecution)eIterator.next();
                if (execution.isEnabled()) continue;
                eIterator.remove();
            }
        }
        executions = executions.subList(0, count);
        return executions;
    }

    public void setFutureExecutionEnabled(long jobId, Date execDate, boolean enabled) {
        Job job = this.get(jobId);
        Set disabledTimes = job.getDisabledTimes();
        long execTime = execDate.getTime();
        if (enabled) {
            if (disabledTimes.contains(execTime)) {
                disabledTimes.remove(execTime);
            }
        } else {
            disabledTimes.add(execTime);
        }
    }

    private List<FutureExecution> getFutureExecutions(Job job, Date afterDate, int numHours) {
        ArrayList<FutureExecution> executions = new ArrayList<FutureExecution>();
        List<Date> execTimes = this.getQuartzScheduler().getFutureExecutions(job.getId(), afterDate, numHours);
        for (Date execTime : execTimes) {
            long execTimeLong;
            FutureExecution futureExecution = new FutureExecution(job, execTime);
            executions.add(futureExecution);
            Set disabledTimes = job.getDisabledTimes();
            if (!disabledTimes.contains(execTimeLong = execTime.getTime())) continue;
            futureExecution.setEnabled(false);
        }
        return executions;
    }

    private ScheduleTime getScheduleTime(ScheduleRule rule) {
        switch (rule.getType()) {
            case ON_DATE: {
                return OnDate.getTime(rule);
            }
            case EVERY_N_DAYS: {
                return EveryNDays.getTime(rule);
            }
            case ON_DAY_EVERY_N_WEEKS: {
                return OnDayEveryNWeeks.getTime(rule);
            }
            case N_DAYS_FROM_METADATA: {
                return Daily.getTime(rule);
            }
        }
        throw new SchedulerException("Unknown Schedule Rule Type: " + rule.getType());
    }

    private Date subtract(Date date, int numHours) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(10, -numHours);
        return cal.getTime();
    }

    private IQuartzScheduler getQuartzScheduler() {
        try {
            return (IQuartzScheduler)new InitialContext().lookup("/cms/QuartzScheduler/local");
        }
        catch (Exception ex) {
            throw new SchedulerException("Cannot obtain IQuartzScheduler bean", (Throwable)ex);
        }
    }

    private Session getSession() {
        return HibernateContext.getContext().getCurrentSession();
    }
}

