/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.scheduler.quartz;

import com.ericsson.cms.scheduler.IScheduler;
import com.ericsson.cms.scheduler.ISchedulerCallback;
import com.ericsson.cms.scheduler.entities.PastExecution;
import com.ericsson.cms.scheduler.entities.ScheduleRule;
import com.ericsson.cms.scheduler.entities.ScheduleRuleType;
import com.tandbergtv.watchpoint.pmm.dao.hibernate.HibernateContext;
import java.util.Calendar;
import java.util.Date;
import java.util.Set;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.TransactionManager;
import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.quartz.Job;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class QuartzCallback
implements Job {
    private static final Logger logger = Logger.getLogger(QuartzCallback.class);

    public void execute(JobExecutionContext execContext) throws JobExecutionException {
        JobDetail jobDetail = execContext.getJobDetail();
        this.execute(jobDetail.getName(), execContext.getScheduledFireTime());
    }

    public void execute(String jobName, Date execDate) {
        long execTime;
        com.ericsson.cms.scheduler.entities.Job job = this.getScheduler().get(Long.parseLong(jobName));
        if (job == null) {
            logger.error((Object)("Exception while trying to execute the job: " + jobName + " | Job not found."));
            return;
        }
        boolean enabled = true;
        Set disabledTimes = job.getDisabledTimes();
        if (disabledTimes.contains(execTime = execDate.getTime())) {
            enabled = false;
        }
        try {
            TransactionManager transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            boolean transactionStartedHere = false;
            if (transactionManager.getTransaction() == null) {
                transactionManager.begin();
                transactionStartedHere = true;
            }
            this.getSession().saveOrUpdate((Object)new PastExecution(job, execDate, enabled));
            if (transactionStartedHere) {
                transactionManager.commit();
            }
        }
        catch (Exception e) {
            logger.error((Object)"Exception while saving execution record.", (Throwable)e);
        }
        if (enabled) {
            ISchedulerCallback callback;
            Class callbackClass = job.getCallbackClass();
            try {
                callback = (ISchedulerCallback)callbackClass.newInstance();
            }
            catch (Exception e) {
                logger.error((Object)("Exception while trying to execute the job: " + jobName + " | Could not instantiate the callback class."), (Throwable)e);
                return;
            }
            String filterName = null;
            Date filterValue = null;
            ScheduleRule rule = job.getRule();
            if (rule.getType() == ScheduleRuleType.N_DAYS_FROM_METADATA) {
                filterName = rule.getParam(3).getValue();
                filterValue = this.getDate(rule.getParam(1).getValue(), rule.getParam(2).getValue(), execDate);
            }
            try {
                callback.performAction(job.getId().longValue(), job.getAssociatedEntityType(), job.getAssociatedEntities(), filterName, filterValue, execDate);
            }
            catch (Throwable t) {
                logger.error((Object)("Exception while trying to execute the job: " + jobName + " | Callback class threw an exception."), t);
            }
        }
    }

    private IScheduler getScheduler() {
        try {
            return (IScheduler)new InitialContext().lookup("/cms/Scheduler/local");
        }
        catch (NamingException e) {
            throw new RuntimeException("Scheduler cannot be obtained.", e);
        }
    }

    private Date getDate(String numDays, String beforeAfter, Date execDate) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(execDate);
        int numberOfDays = Integer.parseInt(numDays);
        if (beforeAfter.equalsIgnoreCase("after")) {
            calendar.add(5, -numberOfDays);
        } else if (beforeAfter.equalsIgnoreCase("before")) {
            calendar.add(5, numberOfDays);
        }
        return calendar.getTime();
    }

    private Session getSession() {
        return HibernateContext.getContext().getCurrentSession();
    }
}

