/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.scheduler.timers;

import com.ericsson.cms.scheduler.ScheduleTime;
import com.ericsson.cms.scheduler.entities.ScheduleRule;
import com.ericsson.cms.scheduler.timers.TimerHelper;
import java.util.Date;
import org.apache.log4j.Logger;

public class EveryNDays {
    private static long MSEC_IN_ONE_DAY = 86400000L;
    private static final Logger logger = Logger.getLogger(EveryNDays.class);

    public static ScheduleTime getTime(ScheduleRule rule) {
        String numberOfDays = rule.getParam(1).getValue();
        String jobTime = rule.getParam(2).getValue();
        if (numberOfDays == null) {
            logger.error((Object)"Number of days not specified");
            return null;
        }
        if (Integer.parseInt(numberOfDays) == 0) {
            logger.error((Object)"Number of days cannot be 0");
            return null;
        }
        Date jobStartDate = TimerHelper.getStartDateTime(rule.getStartDate(), jobTime);
        long periodicity = Long.parseLong(numberOfDays) * MSEC_IN_ONE_DAY;
        return new ScheduleTime(jobStartDate, rule.getEndDate(), periodicity);
    }
}

