/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.core.entities;

import com.ericsson.cms.sites.core.entities.DistributionSite;
import com.ericsson.cms.sites.core.entities.Site;
import com.ericsson.cms.sites.core.entities.SiteType;
import java.util.HashSet;
import java.util.Set;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@XmlRootElement(name="logicalSite")
public class LogicalSite
extends Site {
    private static final Set<Site> EMPTY_PARENTS = new HashSet<Site>();
    private Set<DistributionSite> children;

    public void setChildren(Set<DistributionSite> children) {
        this.children = children;
    }

    public void addChild(DistributionSite child) {
        if (this.children == null) {
            this.children = new HashSet<DistributionSite>();
        }
        this.children.add(child);
    }

    @XmlTransient
    public Set<DistributionSite> getChildren() {
        return this.children;
    }

    @Override
    public SiteType getType() {
        return SiteType.LOGICAL;
    }

    @Override
    public Set<Site> getSiteChildren() {
        HashSet<Site> siteChildren = new HashSet<Site>();
        if (this.children != null) {
            for (DistributionSite distSiteChild : this.children) {
                siteChildren.add(distSiteChild);
            }
        }
        return siteChildren;
    }

    @Override
    public Set<Site> getSiteParents() {
        return EMPTY_PARENTS;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }
}

