/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.devices.content;

import com.ericsson.cms.devices.content.SoapCaller;
import com.ericsson.cms.devices.content.UtilApi;
import com.tandbergtv.workflow.message.IMessageKey;
import com.tandbergtv.workflow.message.MessageKeyImpl;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class Test_11_Validate_Title_by_Spec {
    static SoapCaller soapCaller;
    static UtilApi utilApi;
    static String msgOrigin;
    static MessageKeyImpl messageKey;
    static IMessageKey messageOrigin;
    Map<String, String> params;
    Map<String, Object> response;
    static int titleId;
    private static final String SPEC = "CL1_1";
    private static final String UID = "01CM11";
    private static Logger logger;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        soapCaller = new SoapCaller();
        utilApi = new UtilApi();
        messageKey = new MessageKeyImpl((Object)msgOrigin);
        messageOrigin = messageKey;
        titleId = utilApi.createTitleForMetadata();
    }

    @Before
    public void setUp() throws Exception {
        this.params = new HashMap<String, String>();
        this.response = new HashMap<String, Object>();
    }

    @After
    public void tearDown() throws Exception {
        this.params = null;
        this.response = null;
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        utilApi.deleteMasterTitle(titleId);
        utilApi = null;
        soapCaller = null;
        messageKey = null;
        messageOrigin = null;
    }

    @Test
    public void testEmptyTitleId() throws Exception {
        this.params.put("titleId", "");
        this.params.put("spec", SPEC);
        logger.debug((Object)"Test_11_Validate_Title_by_Spec testEmptyTitleId Request Params");
        logger.debug((Object)("TitleID -> " + this.params.get("titleId") + " Spec -> " + this.params.get("spec")));
        this.response = soapCaller.invokeApi(UID, messageOrigin, this.params);
        logger.debug((Object)("Test_11_Validate_Title_by_Spec testEmptyTitleId - Error Message : " + this.response.get("error-message")));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testNegativeTitleId() throws Exception {
        this.params.put("titleId", "-1");
        this.params.put("spec", SPEC);
        logger.debug((Object)"Test_11_Validate_Title_by_Spec testNegativeTitleId Request Params");
        logger.debug((Object)("TitleID -> " + this.params.get("titleId") + " Spec -> " + this.params.get("spec")));
        this.response = soapCaller.invokeApi(UID, messageOrigin, this.params);
        logger.debug((Object)("Test_11_Validate_Title_by_Spec testNegativeTitleId - Error Message : " + this.response.get("error-message")));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testStringAsTitleId() throws Exception {
        this.params.put("titleId", "abcd");
        this.params.put("spec", SPEC);
        logger.debug((Object)"Test_11_Validate_Title_by_Spec testStringAsTitleId Request Params");
        logger.debug((Object)("TitleID -> " + this.params.get("titleId") + " Spec -> " + this.params.get("spec")));
        this.response = soapCaller.invokeApi(UID, messageOrigin, this.params);
        logger.debug((Object)("Test_11_Validate_Title_by_Spec testStringAsTitleId - Error Message : " + this.response.get("error-message")));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testEmptySpec() throws Exception {
        this.params.put("titleId", String.valueOf(titleId));
        this.params.put("spec", "");
        logger.debug((Object)"Test_11_Validate_Title_by_Spec testEmptySpec Request Params");
        logger.debug((Object)("TitleID -> " + this.params.get("titleId") + " Spec -> " + this.params.get("spec")));
        Assert.assertTrue((titleId > 0 ? 1 : 0) != 0);
        this.response = soapCaller.invokeApi(UID, messageOrigin, this.params);
        logger.debug((Object)("Test_11_Validate_Title_by_Spec testEmptySpec - Error Message : " + this.response.get("error-message")));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testInvalidSpec() throws Exception {
        this.params.put("titleId", String.valueOf(titleId));
        this.params.put("spec", "xyz123");
        logger.debug((Object)"Test_11_Validate_Title_by_Spec testInvalidSpec Request Params");
        logger.debug((Object)("TitleID -> " + this.params.get("titleId") + " Spec -> " + this.params.get("spec")));
        Assert.assertTrue((titleId > 0 ? 1 : 0) != 0);
        this.response = soapCaller.invokeApi(UID, messageOrigin, this.params);
        logger.debug((Object)("Test_11_Validate_Title_by_Spec testInvalidSpec - Error Message : " + this.response.get("error-message")));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    static {
        msgOrigin = "171219";
        logger = Logger.getLogger(Test_11_Validate_Title_by_Spec.class);
    }
}

