/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.devices.content;

import com.ericsson.cms.devices.content.SoapCaller;
import com.ericsson.cms.devices.content.UtilApi;
import com.tandbergtv.workflow.message.IMessageKey;
import com.tandbergtv.workflow.message.MessageKeyImpl;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class Test_14_Unregister_All_Files {
    static SoapCaller soapCaller;
    static UtilApi utilApi;
    static String msgOrigin;
    static MessageKeyImpl messageKey;
    static IMessageKey messageOrigin;
    Map<String, String> params;
    Map<String, Object> response;
    static int titleId;
    private static final String SOURCE_COMPONENT_NAME = "WatchPoint";
    private static final String SOURCE_ENTITY_NAME = "Workflow";
    private static final String SOURCEID = "171219";
    private static final String UID = "01CM14";
    private static Logger logger;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        soapCaller = new SoapCaller();
        utilApi = new UtilApi();
        messageKey = new MessageKeyImpl((Object)msgOrigin);
        messageOrigin = messageKey;
        titleId = utilApi.createTitleForMetadata();
    }

    @Before
    public void setUp() throws Exception {
        this.params = new HashMap<String, String>();
        this.response = new HashMap<String, Object>();
    }

    @After
    public void tearDown() throws Exception {
        this.params = null;
        this.response = null;
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        utilApi.deleteMasterTitle(titleId);
        utilApi = null;
        soapCaller = null;
        messageKey = null;
        messageOrigin = null;
    }

    @Test
    public void testEmptyTitleId() throws Exception {
        this.params.put("titleId", "");
        this.params.put("sourceComponentName", SOURCE_COMPONENT_NAME);
        this.params.put("sourceEntityName", SOURCE_ENTITY_NAME);
        this.params.put("sourceId", SOURCEID);
        logger.debug((Object)"Test_14_Unregister_All_Files testEmptyTitleId Request Params");
        logger.debug((Object)("TitleID -> " + this.params.get("titleId") + " Source Component Name -> " + this.params.get("sourceComponentName") + " Source Entity Name -> " + this.params.get("sourceEntityName") + " Source Id -> " + this.params.get("sourceId")));
        this.response = soapCaller.invokeApi(UID, messageOrigin, this.params);
        logger.debug((Object)("Test_14_Unregister_All_Files testEmptyTitleId - Error Message : " + this.response.get("error-message")));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testNegativeTitleId() throws Exception {
        this.params.put("titleId", "-1");
        this.params.put("sourceComponentName", SOURCE_COMPONENT_NAME);
        this.params.put("sourceEntityName", SOURCE_ENTITY_NAME);
        this.params.put("sourceId", SOURCEID);
        logger.debug((Object)"Test_14_Unregister_All_Files testNegativeTitleId Request Params");
        logger.debug((Object)("TitleID -> " + this.params.get("titleId") + " Source Component Name -> " + this.params.get("sourceComponentName") + " Source Entity Name -> " + this.params.get("sourceEntityName") + " Source Id -> " + this.params.get("sourceId")));
        this.response = soapCaller.invokeApi(UID, messageOrigin, this.params);
        logger.debug((Object)("Test_14_Unregister_All_Files testNegativeTitleId - Error Message : " + this.response.get("error-message")));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testStringAsTitleId() throws Exception {
        this.params.put("titleId", "abcd");
        this.params.put("sourceComponentName", SOURCE_COMPONENT_NAME);
        this.params.put("sourceEntityName", SOURCE_ENTITY_NAME);
        this.params.put("sourceId", SOURCEID);
        logger.debug((Object)"Test_14_Unregister_All_Files testStringAsTitleId Request Params");
        logger.debug((Object)("TitleID -> " + this.params.get("titleId") + " Source Component Name -> " + this.params.get("sourceComponentName") + " Source Entity Name -> " + this.params.get("sourceEntityName") + " Source Id -> " + this.params.get("sourceId")));
        this.response = soapCaller.invokeApi(UID, messageOrigin, this.params);
        logger.debug((Object)("Test_14_Unregister_All_Files testStringAsTitleId - Error Message : " + this.response.get("error-message")));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testEmptySourceComponentName() throws Exception {
        this.params.put("titleId", String.valueOf(titleId));
        this.params.put("sourceComponentName", "");
        this.params.put("sourceEntityName", SOURCE_ENTITY_NAME);
        this.params.put("sourceId", SOURCEID);
        logger.debug((Object)"Test_14_Unregister_All_Files testEmptySourceComponentName Request Params");
        logger.debug((Object)("TitleID -> " + this.params.get("titleId") + " Source Component Name -> " + this.params.get("sourceComponentName") + " Source Entity Name -> " + this.params.get("sourceEntityName") + " Source Id -> " + this.params.get("sourceId")));
        Assert.assertTrue((titleId > 0 ? 1 : 0) != 0);
        this.response = soapCaller.invokeApi(UID, messageOrigin, this.params);
        logger.debug((Object)("Test_14_Unregister_All_Files testEmptySourceComponentName - Error Message : " + this.response.get("error-message")));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testEmptySourceEntityName() throws Exception {
        this.params.put("titleId", String.valueOf(titleId));
        this.params.put("sourceComponentName", SOURCE_COMPONENT_NAME);
        this.params.put("sourceEntityName", "");
        this.params.put("sourceId", SOURCEID);
        logger.debug((Object)"Test_14_Unregister_All_Files testEmptySourceEntityName Request Params");
        logger.debug((Object)("TitleID -> " + this.params.get("titleId") + " Source Component Name -> " + this.params.get("sourceComponentName") + " Source Entity Name -> " + this.params.get("sourceEntityName") + " Source Id -> " + this.params.get("sourceId")));
        Assert.assertTrue((titleId > 0 ? 1 : 0) != 0);
        this.response = soapCaller.invokeApi(UID, messageOrigin, this.params);
        logger.debug((Object)("Test_14_Unregister_All_Files testEmptySourceEntityName - Error Message : " + this.response.get("error-message")));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testEmptySourcedId() throws Exception {
        this.params.put("titleId", String.valueOf(titleId));
        this.params.put("sourceComponentName", SOURCE_COMPONENT_NAME);
        this.params.put("sourceEntityName", SOURCE_ENTITY_NAME);
        this.params.put("sourceId", "");
        logger.debug((Object)"Test_14_Unregister_All_Files testEmptySourcedId Request Params");
        logger.debug((Object)("TitleID -> " + this.params.get("titleId") + " Source Component Name -> " + this.params.get("sourceComponentName") + " Source Entity Name -> " + this.params.get("sourceEntityName") + " Source Id -> " + this.params.get("sourceId")));
        Assert.assertTrue((titleId > 0 ? 1 : 0) != 0);
        this.response = soapCaller.invokeApi(UID, messageOrigin, this.params);
        logger.debug((Object)("Test_14_Unregister_All_Files testEmptySourcedId - Error Message : " + this.response.get("error-message")));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    static {
        msgOrigin = SOURCEID;
        logger = Logger.getLogger(Test_14_Unregister_All_Files.class);
    }
}

