/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.devices.content;

import com.ericsson.cms.devices.content.SoapCaller;
import com.tandbergtv.workflow.message.IMessageKey;
import com.tandbergtv.workflow.message.MessageKeyImpl;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class Test_37_Create_Title_for_Package {
    static SoapCaller soapCaller;
    static String msgOrigin;
    static MessageKeyImpl messageKey;
    static IMessageKey messageOrigin;
    Map<String, String> params;
    Map<String, Object> response;
    private static final String UID = "01CM37";
    private static final String METADATA_PATH = "/opt/tandbergtv/cms/workflow/lib/content-management-template/MetaData/ADI.XML";
    private static final String ASSET_FOLDER_PATH = "/opt/tandbergtv/cms/workflow/lib/content-management-template/MetaData";
    private static final String PROVIDER_ID = "TTV.COM";
    private static final String CONTENT_CLASS_NAME = "Default";
    private static Logger logger;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        soapCaller = new SoapCaller();
        messageKey = new MessageKeyImpl((Object)msgOrigin);
        messageOrigin = messageKey;
    }

    @Before
    public void setUp() throws Exception {
        this.params = new HashMap<String, String>();
        this.response = new HashMap<String, Object>();
    }

    @After
    public void tearDown() throws Exception {
        this.params = null;
        this.response = null;
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        soapCaller = null;
        messageKey = null;
        messageOrigin = null;
    }

    @Test
    public void testEmptyMetadataPath() throws Exception {
        this.params.put("metadataPath", "");
        this.params.put("assetFolderPath", ASSET_FOLDER_PATH);
        this.params.put("providerId", PROVIDER_ID);
        this.params.put("contentClassName", CONTENT_CLASS_NAME);
        logger.debug((Object)"Test_37_Create_Title_for_Package testEmptyMetadataPath Request Params");
        logger.debug((Object)("Metadata Path -> " + this.params.get("metadataPath") + " AssetFolder Path -> " + this.params.get("assetFolderPath") + " Provider Id -> " + this.params.get("providerId") + " ContentClass Name -> " + this.params.get("contentClassName")));
        this.response = soapCaller.invokeApi(UID, messageOrigin, this.params);
        logger.debug((Object)("Test_37_Create_Title_for_Package testEmptyMetadataPath - TitleId : " + this.response.get("titleId")));
        logger.debug((Object)("Test_37_Create_Title_for_Package testEmptyMetadataPath - Error Message : " + this.response.get("error-message")));
        Assert.assertNull((Object)this.response.get("titleId"));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testInvalidMetadataPath() throws Exception {
        this.params.put("metadataPath", "abcd1234");
        this.params.put("assetFolderPath", ASSET_FOLDER_PATH);
        this.params.put("providerId", PROVIDER_ID);
        this.params.put("contentClassName", CONTENT_CLASS_NAME);
        logger.debug((Object)"Test_37_Create_Title_for_Package testInvalidMetadataPath Request Params");
        logger.debug((Object)("Metadata Path -> " + this.params.get("metadataPath") + " AssetFolder Path -> " + this.params.get("assetFolderPath") + " Provider Id -> " + this.params.get("providerId") + " ContentClass Name -> " + this.params.get("contentClassName")));
        this.response = soapCaller.invokeApi(UID, messageOrigin, this.params);
        logger.debug((Object)("Test_37_Create_Title_for_Package testInvalidMetadataPath - TitleId : " + this.response.get("titleId")));
        logger.debug((Object)("Test_37_Create_Title_for_Package testInvalidMetadataPath - Error Message : " + this.response.get("error-message")));
        Assert.assertNull((Object)this.response.get("titleId"));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testEmptyAssetFolderPath() throws Exception {
        this.params.put("metadataPath", METADATA_PATH);
        this.params.put("assetFolderPath", "");
        this.params.put("providerId", PROVIDER_ID);
        this.params.put("contentClassName", CONTENT_CLASS_NAME);
        logger.debug((Object)"Test_37_Create_Title_for_Package testEmptyAssetFolderPath Request Params");
        logger.debug((Object)("Metadata Path -> " + this.params.get("metadataPath") + " AssetFolder Path -> " + this.params.get("assetFolderPath") + " Provider Id -> " + this.params.get("providerId") + " ContentClass Name -> " + this.params.get("contentClassName")));
        this.response = soapCaller.invokeApi(UID, messageOrigin, this.params);
        logger.debug((Object)("Test_37_Create_Title_for_Package testEmptyAssetFolderPath - TitleId : " + this.response.get("titleId")));
        logger.debug((Object)("Test_37_Create_Title_for_Package testEmptyAssetFolderPath - Error Message : " + this.response.get("error-message")));
        Assert.assertNull((Object)this.response.get("titleId"));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testInvalidAssetFolderPath() throws Exception {
        this.params.put("metadataPath", METADATA_PATH);
        this.params.put("assetFolderPath", "abcd1234");
        this.params.put("providerId", PROVIDER_ID);
        this.params.put("contentClassName", CONTENT_CLASS_NAME);
        logger.debug((Object)"Test_37_Create_Title_for_Package testInvalidAssetFolderPath Request Params");
        logger.debug((Object)("Metadata Path -> " + this.params.get("metadataPath") + " AssetFolder Path -> " + this.params.get("assetFolderPath") + " Provider Id -> " + this.params.get("providerId") + " ContentClass Name -> " + this.params.get("contentClassName")));
        this.response = soapCaller.invokeApi(UID, messageOrigin, this.params);
        logger.debug((Object)("Test_37_Create_Title_for_Package testInvalidAssetFolderPath - TitleId : " + this.response.get("titleId")));
        logger.debug((Object)("Test_37_Create_Title_for_Package testInvalidAssetFolderPath - Error Message : " + this.response.get("error-message")));
        Assert.assertNull((Object)this.response.get("titleId"));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testEmptyProviderId() throws Exception {
        this.params.put("metadataPath", METADATA_PATH);
        this.params.put("assetFolderPath", ASSET_FOLDER_PATH);
        this.params.put("providerId", "");
        this.params.put("contentClassName", CONTENT_CLASS_NAME);
        logger.debug((Object)"Test_37_Create_Title_for_Package testEmptyProviderId Request Params");
        logger.debug((Object)("Metadata Path -> " + this.params.get("metadataPath") + " AssetFolder Path -> " + this.params.get("assetFolderPath") + " Provider Id -> " + this.params.get("providerId") + " ContentClass Name -> " + this.params.get("contentClassName")));
        this.response = soapCaller.invokeApi(UID, messageOrigin, this.params);
        logger.debug((Object)("Test_37_Create_Title_for_Package testEmptyProviderId - TitleId : " + this.response.get("titleId")));
        logger.debug((Object)("Test_37_Create_Title_for_Package testEmptyProviderId - Error Message : " + this.response.get("error-message")));
        Assert.assertNull((Object)this.response.get("titleId"));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testInvalidProviderId() throws Exception {
        this.params.put("metadataPath", METADATA_PATH);
        this.params.put("assetFolderPath", ASSET_FOLDER_PATH);
        this.params.put("providerId", "xyz123");
        this.params.put("contentClassName", CONTENT_CLASS_NAME);
        logger.debug((Object)"Test_37_Create_Title_for_Package testInvalidProviderId Request Params");
        logger.debug((Object)("Metadata Path -> " + this.params.get("metadataPath") + " AssetFolder Path -> " + this.params.get("assetFolderPath") + " Provider Id -> " + this.params.get("providerId") + " ContentClass Name -> " + this.params.get("contentClassName")));
        this.response = soapCaller.invokeApi(UID, messageOrigin, this.params);
        logger.debug((Object)("Test_37_Create_Title_for_Package testInvalidProviderId - TitleId : " + this.response.get("titleId")));
        logger.debug((Object)("Test_37_Create_Title_for_Package testInvalidProviderId - Error Message : " + this.response.get("error-message")));
        Assert.assertNull((Object)this.response.get("titleId"));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testInvalidContentClassName() throws Exception {
        this.params.put("metadataPath", METADATA_PATH);
        this.params.put("assetFolderPath", ASSET_FOLDER_PATH);
        this.params.put("providerId", PROVIDER_ID);
        this.params.put("contentClassName", "abcd");
        logger.debug((Object)"Test_37_Create_Title_for_Package testInvalidContentClassName Request Params");
        logger.debug((Object)("Metadata Path -> " + this.params.get("metadataPath") + " AssetFolder Path -> " + this.params.get("assetFolderPath") + " Provider Id -> " + this.params.get("providerId") + " ContentClass Name -> " + this.params.get("contentClassName")));
        this.response = soapCaller.invokeApi(UID, messageOrigin, this.params);
        logger.debug((Object)("Test_37_Create_Title_for_Package testInvalidContentClassName - TitleId : " + this.response.get("titleId")));
        logger.debug((Object)("Test_37_Create_Title_for_Package testInvalidContentClassName - Error Message : " + this.response.get("error-message")));
        Assert.assertNull((Object)this.response.get("titleId"));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    static {
        msgOrigin = "171381";
        logger = Logger.getLogger(Test_37_Create_Title_for_Package.class);
    }
}

