/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.devices.content;

import com.ericsson.cms.devices.content.SoapCaller;
import com.ericsson.cms.devices.content.UtilApi;
import com.tandbergtv.workflow.message.IMessageKey;
import com.tandbergtv.workflow.message.MessageKeyImpl;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class Test_43_Get_Mapping_for_Content {
    static SoapCaller soapCaller;
    static String msgOrigin;
    static MessageKeyImpl messageKey;
    static IMessageKey messageOrigin;
    static UtilApi utilApi;
    static int titleId;
    Map<String, String> params;
    Map<String, Object> response;
    private static final String UID = "01CM43";
    private static final String ASSET_PATH = "PACKAGE/POSTER/TTV_Poster_474080.bmp";
    private static final String PROVIDER_ID = "TTV.COM";
    private static Logger logger;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        soapCaller = new SoapCaller();
        messageKey = new MessageKeyImpl((Object)msgOrigin);
        messageOrigin = messageKey;
        utilApi = new UtilApi();
        titleId = utilApi.createTitleForMetadata();
    }

    @Before
    public void setUp() throws Exception {
        this.params = new HashMap<String, String>();
        this.response = new HashMap<String, Object>();
    }

    @After
    public void tearDown() throws Exception {
        this.params = null;
        this.response = null;
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        utilApi.deleteMasterTitle(titleId);
        utilApi = null;
        soapCaller = null;
        messageKey = null;
        messageOrigin = null;
    }

    @Test
    public void testEmptyAssetPath() throws Exception {
        this.params.put("assetPath", "");
        this.params.put("providerId", PROVIDER_ID);
        logger.debug((Object)"Test_43_Get_Mapping_for_Content testEmptyAssetPath Request Params");
        logger.debug((Object)("Asset Path -> " + this.params.get("assetPath") + " Provider Id -> " + this.params.get("providerId")));
        this.response = soapCaller.invokeApi(UID, messageOrigin, this.params);
        logger.debug((Object)("Test_43_Get_Mapping_for_Content testEmptyAssetPath - TitleId : " + this.response.get("titleId")));
        logger.debug((Object)("Test_43_Get_Mapping_for_Content testEmptyAssetPath - Error Message : " + this.response.get("error-message")));
        Assert.assertNull((Object)this.response.get("titleId"));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testEmptyProviderId() throws Exception {
        this.params.put("assetPath", ASSET_PATH);
        this.params.put("providerId", "");
        logger.debug((Object)"Test_43_Get_Mapping_for_Content testEmptyProviderId Request Params");
        logger.debug((Object)("Asset Path -> " + this.params.get("assetPath") + " Provider Id -> " + this.params.get("providerId")));
        this.response = soapCaller.invokeApi(UID, messageOrigin, this.params);
        logger.debug((Object)("Test_43_Get_Mapping_for_Content testEmptyProviderId - TitleId : " + this.response.get("titleId")));
        logger.debug((Object)("Test_43_Get_Mapping_for_Content testEmptyProviderId - Error Message : " + this.response.get("error-message")));
        Assert.assertNull((Object)this.response.get("titleId"));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    static {
        msgOrigin = "171381";
        logger = Logger.getLogger(Test_43_Get_Mapping_for_Content.class);
    }
}

