/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.devices.content;

import com.ericsson.cms.devices.content.SoapCaller;
import com.ericsson.cms.devices.content.UtilApi;
import com.tandbergtv.workflow.message.IMessageKey;
import com.tandbergtv.workflow.message.MessageKeyImpl;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class Test_71_Get_Unmapped_Content_Path_for_Title_Asset {
    static SoapCaller soapCaller;
    static UtilApi utilApi;
    static String msgOrigin;
    static MessageKeyImpl messageKey;
    static IMessageKey messageOrigin;
    Map<String, String> params;
    Map<String, Object> response;
    static int titleId;
    static int assetId;
    static String assetType;
    private static final String UID = "01CM71";
    private static Logger logger;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        soapCaller = new SoapCaller();
        utilApi = new UtilApi();
        messageKey = new MessageKeyImpl((Object)msgOrigin);
        messageOrigin = messageKey;
        titleId = utilApi.createTitleForMetadata();
        assetId = utilApi.getAssetId(titleId, assetType);
    }

    @Before
    public void setUp() throws Exception {
        this.params = new HashMap<String, String>();
        this.response = new HashMap<String, Object>();
    }

    @After
    public void tearDown() throws Exception {
        this.params = null;
        this.response = null;
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        utilApi.deleteMasterTitle(titleId);
        utilApi = null;
        soapCaller = null;
        messageKey = null;
        messageOrigin = null;
    }

    @Test
    public void testEmptyTitleId() throws Exception {
        this.params.put("titleId", "");
        this.params.put("assetId", String.valueOf(assetId));
        logger.debug((Object)"Test_71_Get_Unmapped_Content_Path_for_Title_Asset testEmptyTitleId Request Params");
        logger.debug((Object)("TitleID -> " + this.params.get("titleId") + " AssetId -> " + this.params.get("assetId")));
        Assert.assertTrue((assetId > 1 ? 1 : 0) != 0);
        this.response = soapCaller.invokeApi(UID, messageOrigin, this.params);
        logger.debug((Object)("Test_71_Get_Unmapped_Content_Path_for_Title_Asset testEmptyTitleId - File Count : " + this.response.get("fileCount")));
        logger.debug((Object)("Test_71_Get_Unmapped_Content_Path_for_Title_Asset testEmptyTitleId - Error Message : " + this.response.get("error-message")));
        Assert.assertNull((Object)this.response.get("fileCount"));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testNegativeTitleId() throws Exception {
        this.params.put("titleId", "-1");
        this.params.put("assetId", String.valueOf(assetId));
        logger.debug((Object)"Test_71_Get_Unmapped_Content_Path_for_Title_Asset testNegativeTitleId Request Params");
        logger.debug((Object)("TitleID -> " + this.params.get("titleId") + " AssetId -> " + this.params.get("assetId")));
        Assert.assertTrue((assetId > 1 ? 1 : 0) != 0);
        this.response = soapCaller.invokeApi(UID, messageOrigin, this.params);
        logger.debug((Object)("Test_71_Get_Unmapped_Content_Path_for_Title_Asset testNegativeTitleId - File Count : " + this.response.get("fileCount")));
        logger.debug((Object)("Test_71_Get_Unmapped_Content_Path_for_Title_Asset testNegativeTitleId - Error Message : " + this.response.get("error-message")));
        Assert.assertNull((Object)this.response.get("fileCount"));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testStringAsTitleId() throws Exception {
        this.params.put("titleId", "abcd");
        this.params.put("assetId", String.valueOf(assetId));
        logger.debug((Object)"Test_71_Get_Unmapped_Content_Path_for_Title_Asset testStringAsTitleId Request Params");
        logger.debug((Object)("TitleID -> " + this.params.get("titleId") + " AssetId -> " + this.params.get("assetId")));
        Assert.assertTrue((assetId > 1 ? 1 : 0) != 0);
        this.response = soapCaller.invokeApi(UID, messageOrigin, this.params);
        logger.debug((Object)("Test_71_Get_Unmapped_Content_Path_for_Title_Asset testStringAsTitleId - File Count : " + this.response.get("fileCount")));
        logger.debug((Object)("Test_71_Get_Unmapped_Content_Path_for_Title_Asset testStringAsTitleId - Error Message : " + this.response.get("error-message")));
        Assert.assertNull((Object)this.response.get("fileCount"));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testEmptyAssetId() throws Exception {
        this.params.put("titleId", String.valueOf(titleId));
        this.params.put("assetId", "");
        logger.debug((Object)"Test_71_Get_Unmapped_Content_Path_for_Title_Asset testEmptyAssetId Request Params");
        logger.debug((Object)("TitleID -> " + this.params.get("titleId") + " AssetId -> " + this.params.get("assetId")));
        Assert.assertTrue((titleId > 1 ? 1 : 0) != 0);
        this.response = soapCaller.invokeApi(UID, messageOrigin, this.params);
        logger.debug((Object)("Test_71_Get_Unmapped_Content_Path_for_Title_Asset testEmptyAssetId - File Count : " + this.response.get("fileCount")));
        logger.debug((Object)("Test_71_Get_Unmapped_Content_Path_for_Title_Asset testEmptyAssetId - Error Message : " + this.response.get("error-message")));
        Assert.assertNull((Object)this.response.get("fileCount"));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testNegativeAssetId() throws Exception {
        this.params.put("titleId", String.valueOf(titleId));
        this.params.put("assetId", "-1");
        logger.debug((Object)"Test_71_Get_Unmapped_Content_Path_for_Title_Asset testNegativeAssetId Request Params");
        logger.debug((Object)("TitleID -> " + this.params.get("titleId") + " AssetId -> " + this.params.get("assetId")));
        Assert.assertTrue((titleId > 1 ? 1 : 0) != 0);
        this.response = soapCaller.invokeApi(UID, messageOrigin, this.params);
        logger.debug((Object)("Test_71_Get_Unmapped_Content_Path_for_Title_Asset testNegativeAssetId - File Count : " + this.response.get("fileCount")));
        logger.debug((Object)("Test_71_Get_Unmapped_Content_Path_for_Title_Asset testNegativeAssetId - Error Message : " + this.response.get("error-message")));
        Assert.assertNull((Object)this.response.get("fileCount"));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testStringAsAssetId() throws Exception {
        this.params.put("titleId", String.valueOf(titleId));
        this.params.put("assetId", "abcd");
        logger.debug((Object)"Test_71_Get_Unmapped_Content_Path_for_Title_Asset testStringAsAssetId Request Params");
        logger.debug((Object)("TitleID -> " + this.params.get("titleId") + " AssetId -> " + this.params.get("assetId")));
        Assert.assertTrue((titleId > 1 ? 1 : 0) != 0);
        this.response = soapCaller.invokeApi(UID, messageOrigin, this.params);
        logger.debug((Object)("Test_71_Get_Unmapped_Content_Path_for_Title_Asset testStringAsAssetId - File Count : " + this.response.get("fileCount")));
        logger.debug((Object)("Test_71_Get_Unmapped_Content_Path_for_Title_Asset testStringAsAssetId - Error Message : " + this.response.get("error-message")));
        Assert.assertNull((Object)this.response.get("fileCount"));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    static {
        msgOrigin = "171219";
        assetType = "POSTER";
        logger = Logger.getLogger(Test_71_Get_Unmapped_Content_Path_for_Title_Asset.class);
    }
}

