/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.devices.sites;

import com.ericsson.cms.devices.sites.SoapCaller;
import com.ericsson.cms.devices.sites.UtilApi;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestCreateSiteTitle {
    static String destUrl;
    static SoapCaller soapCaller;
    static UtilApi utilApi;
    String UID;
    static int titleId;
    Map<String, String> params;
    Map<String, Object> response;
    private static Logger logger;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        soapCaller = new SoapCaller();
        destUrl = soapCaller.getUrl();
        utilApi = new UtilApi(destUrl);
        titleId = utilApi.createTitleForMetadata();
        logger.debug((Object)("TestCreateSiteTitle setUpBeforeClass titleId ->" + titleId));
    }

    @Before
    public void setUp() throws Exception {
        this.params = new HashMap<String, String>();
        this.response = new HashMap<String, Object>();
    }

    @After
    public void tearDown() throws Exception {
        this.UID = null;
        this.params = null;
        this.response = null;
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        utilApi.deleteMasterTitle(titleId);
        destUrl = null;
        soapCaller = null;
        utilApi = null;
    }

    @Test
    public void testEmptyTitleId() throws Exception {
        int sId = utilApi.getSiteId("TestMediaPathSite");
        Assert.assertTrue((sId > 0 ? 1 : 0) != 0);
        logger.debug((Object)("TestCreateSiteTitle EmptyTitleId: SiteId - " + sId));
        this.UID = "01SM01";
        this.params.put("TitleID", "");
        this.params.put("SiteID", String.valueOf(sId));
        this.response = soapCaller.invokeApi(this.UID, this.params);
        logger.debug((Object)("TestCreateSiteTitle EmptyTitleId: SiteTitleId -" + this.response.get("SiteTitleID") + " Response Message -" + this.response.toString()));
        Assert.assertNull((Object)this.response.get("SiteTitleID"));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testNegativeTitleId() throws Exception {
        int sId = utilApi.getSiteId("TestLogicalSite");
        Assert.assertTrue((sId > 0 ? 1 : 0) != 0);
        logger.debug((Object)("TestCreateSiteTitle NegativeTitleId: SiteId - " + sId));
        this.UID = "01SM01";
        this.params.put("TitleID", "-642");
        this.params.put("SiteID", String.valueOf(sId));
        this.response = soapCaller.invokeApi(this.UID, this.params);
        logger.debug((Object)("TestCreateSiteTitle NegativeTitleId: SiteTitleId -" + this.response.get("SiteTitleID") + " Response Message -" + this.response.toString()));
        Assert.assertNull((Object)this.response.get("SiteTitleID"));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testStringAsTitleId() throws Exception {
        int sId = utilApi.getSiteId("TestLogicalSite");
        Assert.assertTrue((sId > 0 ? 1 : 0) != 0);
        logger.debug((Object)("TestCreateSiteTitle StringAsTitleId: SiteId - " + sId));
        this.UID = "01SM01";
        this.params.put("TitleID", "abcd");
        this.params.put("SiteID", String.valueOf(sId));
        this.response = soapCaller.invokeApi(this.UID, this.params);
        logger.debug((Object)("TestCreateSiteTitle StringAsTitleId: SiteTitleId -" + this.response.get("SiteTitleID") + " Response Message -" + this.response.toString()));
        Assert.assertNull((Object)this.response.get("SiteTitleID"));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testEmptySiteId() throws Exception {
        this.UID = "01SM01";
        this.params.put("TitleID", String.valueOf(titleId));
        this.params.put("SiteID", "");
        this.response = soapCaller.invokeApi(this.UID, this.params);
        logger.debug((Object)("TestCreateSiteTitle EmptySiteId: SiteTitleId -" + this.response.get("SiteTitleID") + " Response Message -" + this.response.toString()));
        Assert.assertNull((Object)this.response.get("SiteTitleID"));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testNegativeSiteId() throws Exception {
        this.UID = "01SM01";
        this.params.put("TitleID", String.valueOf(titleId));
        this.params.put("SiteID", "-20");
        this.response = soapCaller.invokeApi(this.UID, this.params);
        logger.debug((Object)("TestCreateSiteTitle NegativeSiteId : SiteTitleId -" + this.response.get("SiteTitleID") + " Response Message -" + this.response.toString()));
        Assert.assertNull((Object)this.response.get("SiteTitleID"));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testStringAsSiteId() throws Exception {
        this.UID = "01SM01";
        this.params.put("TitleID", String.valueOf(titleId));
        this.params.put("SiteID", "abcd");
        this.response = soapCaller.invokeApi(this.UID, this.params);
        logger.debug((Object)("TestCreateSiteTitle NegativeSiteId : SiteTitleId -" + this.response.get("SiteTitleID") + " Response Message -" + this.response.toString()));
        Assert.assertNull((Object)this.response.get("SiteTitleID"));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testInactiveSite() throws Exception {
        int sId = utilApi.getSiteId("TestLogicalSite");
        Assert.assertTrue((sId > 0 ? 1 : 0) != 0);
        logger.debug((Object)("TestCreateSiteTitle InactiveSite: SiteId - " + sId));
        this.UID = "01SM01";
        this.params.put("TitleID", String.valueOf(titleId));
        this.params.put("SiteID", String.valueOf(sId));
        logger.debug((Object)("TestCreateSiteTitle-Deactivating the Site : SiteID " + sId));
        utilApi.deactivateSite(sId);
        this.response = soapCaller.invokeApi(this.UID, this.params);
        logger.debug((Object)("TestCreateSiteTitle InactiveSite: SiteTitleId -" + this.response.get("SiteTitleID") + " Response Message -" + this.response.toString()));
        Assert.assertNull((Object)this.response.get("SiteTitleID"));
        Assert.assertNotNull((Object)this.response.get("error-message"));
        logger.debug((Object)("TestCreateSiteTitle-Activating back the Site : SiteID " + sId));
        utilApi.activateSite(sId);
    }

    static {
        logger = Logger.getLogger(TestCreateSiteTitle.class);
    }
}

