/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.devices.sites;

import com.ericsson.cms.devices.sites.SoapCaller;
import com.ericsson.cms.devices.sites.TestCreateSiteTitle;
import com.ericsson.cms.devices.sites.UtilApi;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestGetSiteTitleDetails {
    static String destUrl;
    static SoapCaller soapCaller;
    static UtilApi utilApi;
    String UID;
    Map<String, String> params;
    Map<String, Object> response;
    private Logger logger = Logger.getLogger(TestCreateSiteTitle.class);

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        soapCaller = new SoapCaller();
        destUrl = soapCaller.getUrl();
        utilApi = new UtilApi(destUrl);
    }

    @Before
    public void setUp() throws Exception {
        this.params = new HashMap<String, String>();
        this.response = new HashMap<String, Object>();
    }

    @After
    public void tearDown() throws Exception {
        this.UID = null;
        this.params = null;
        this.response = null;
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        destUrl = null;
        soapCaller = null;
        utilApi = null;
    }

    @Test
    public void testEmptySiteTitleId() throws Exception {
        this.UID = "01SM15";
        this.params.put("SiteTitleID", "");
        this.response = soapCaller.invokeApi(this.UID, this.params);
        this.logger.debug((Object)("TestGetSiteTitleDetails EmptySiteTitleId: MasterTitleId -" + this.response.get("MasterTitleId") + " Response Message -" + this.response.toString()));
        Assert.assertNull((Object)this.response.get("MasterTitleId"));
        Assert.assertNull((Object)this.response.get("distributedVersion"));
        Assert.assertNull((Object)this.response.get("distributionStatus"));
        Assert.assertNull((Object)this.response.get("SiteID"));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testNegativeSiteTitleId() throws Exception {
        this.UID = "01SM15";
        this.params.put("SiteTitleID", "-20");
        this.response = soapCaller.invokeApi(this.UID, this.params);
        this.logger.debug((Object)("TestGetSiteTitleDetails NegativeSiteTitleId: MasterTitleId -" + this.response.get("MasterTitleId") + " Response Message -" + this.response.toString()));
        Assert.assertNull((Object)this.response.get("MasterTitleId"));
        Assert.assertNull((Object)this.response.get("distributedVersion"));
        Assert.assertNull((Object)this.response.get("distributionStatus"));
        Assert.assertNull((Object)this.response.get("SiteID"));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testStringAsSiteTitleId() throws Exception {
        this.UID = "01SM15";
        this.params.put("SiteTitleID", "abcd");
        this.response = soapCaller.invokeApi(this.UID, this.params);
        this.logger.debug((Object)("TestGetSiteTitleDetails StringAsSiteTitleId: MasterTitleId -" + this.response.get("MasterTitleId") + " Response Message -" + this.response.toString()));
        Assert.assertNull((Object)this.response.get("MasterTitleId"));
        Assert.assertNull((Object)this.response.get("distributedVersion"));
        Assert.assertNull((Object)this.response.get("distributionStatus"));
        Assert.assertNull((Object)this.response.get("SiteID"));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }
}

