/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.adaptor.boot;

import com.tandbergtv.watchpoint.boot.Platform;
import com.tandbergtv.workflow.adaptor.IAdaptorService;
import com.tandbergtv.workflow.adaptor.internal.AdaptorService;
import com.tandbergtv.workflow.core.event.DefaultMediator;
import com.tandbergtv.workflow.core.event.IColleague;
import com.tandbergtv.workflow.core.licensing.InvalidLicenseException;
import com.tandbergtv.workflow.core.licensing.LicenseKeyConstants;
import com.tandbergtv.workflow.core.licensing.LicenseManager;
import com.tandbergtv.workflow.core.queue.Queue;
import com.tandbergtv.workflow.core.queue.monitor.IQueueMonitor;
import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.message.queue.OffloadQueueProvider;
import com.tandbergtv.workflow.message.command.internal.CommandExecutor;
import com.tandbergtv.workflow.pluginmanager.PluginManagement;
import com.tandbergtv.workflow.pluginmanager.WatchPointPluginManager;
import com.tandbergtv.workflow.util.ApplicationProperties;
import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.apache.log4j.Logger;
import org.java.plugin.PluginManager;

public class Activator {
    private static final String MQ_MBEAN_NAME = "com.tandbergtv.watchpoint:type=Queue,name=mq";
    private static final Logger logger = Logger.getLogger(Activator.class);

    public void start() {
        ServiceRegistry registry = ServiceRegistry.getDefault();
        CommandExecutor executor = new CommandExecutor();
        this.addService(executor);
        String dir = this.getOffloadQueueDir();
        OffloadQueueProvider provider = new OffloadQueueProvider(executor, dir);
        Queue queue = provider.createQueue();
        Service service = (Service)queue;
        registry.register(service.getServiceName(), service);
        DefaultMediator.getInstance().register((IColleague)IColleague.class.cast(queue));
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        try {
            StandardMBean mbean = new StandardMBean((IQueueMonitor)queue, IQueueMonitor.class);
            server.registerMBean(mbean, new ObjectName(MQ_MBEAN_NAME));
        }
        catch (Exception e) {
            logger.warn((Object)"Message offload queue monitoring will not be available", (Throwable)e);
        }
        PluginManager pluginManager = Platform.getPlatform().getPluginManager();
        this.addService((Service)new WatchPointPluginManager(pluginManager, this.getMaxResourceTypes()));
        this.addService(new AdaptorService());
    }

    public void stop() {
        this.removeService(IAdaptorService.class);
        this.removeService(PluginManagement.class);
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        try {
            server.unregisterMBean(new ObjectName(MQ_MBEAN_NAME));
        }
        catch (Exception e) {
            logger.warn((Object)"Message offload queue MBean unregistration failed");
        }
        ServiceRegistry registry = ServiceRegistry.getDefault();
        Service service = registry.lookup("com.tandbergtv.workflow.mq");
        if (service != null) {
            DefaultMediator.getInstance().unregister((IColleague)IColleague.class.cast(service));
            service.stop();
            registry.unregister(service);
        }
        this.removeService(CommandExecutor.class);
    }

    private String getOffloadQueueDir() {
        String dir = null;
        try {
            dir = ApplicationProperties.getInstance().getProperty("install.dir");
        }
        catch (Exception e) {
            throw new RuntimeException("Application install directory is not configured", e);
        }
        return dir;
    }

    private void addService(Service service) {
        ServiceRegistry.getDefault().register(service.getServiceName(), service);
        service.start();
    }

    private void removeService(Class<? extends Service> clazz) {
        ServiceRegistry registry = ServiceRegistry.getDefault();
        Service service = (Service)registry.lookup(clazz);
        if (service != null) {
            service.stop();
            registry.unregister(service);
        }
    }

    private int getMaxResourceTypes() {
        LicenseManager lm = LicenseManager.getInstance();
        int count = Integer.MAX_VALUE;
        try {
            String string = lm.getObject(LicenseKeyConstants.RESOURCE_TYPES);
            if (string == null || string.trim().length() == 0) {
                return count;
            }
            count = Integer.parseInt(string.trim());
            if (count < 0) {
                throw new RuntimeException("Invalid license - resource type limit must be a positive value");
            }
        }
        catch (InvalidLicenseException e) {
            throw new RuntimeException("Invalid license", e);
        }
        return count;
    }
}

