/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core.licensing;

import com.tandbergtv.workflow.core.licensing.ILicenseReader;
import com.tandbergtv.workflow.core.licensing.InvalidLicenseException;
import com.tandbergtv.workflow.core.licensing.LicenseKey;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class LicenseManager {
    private static ILicenseReader licenseReader;
    private static final String CONFIG_PROPERTIES_FILE_PATH = "com/tandbergtv/workflow/core/licensing/license-config.properties";
    private static final String CLASS_NAME = "className";
    private static final String PASSWORD = "TandbergTelevisionPartOfTheEricssonGroup";
    private static final String EXPIRATION_DATE = "expirationDate";
    private static Logger logger;

    public static LicenseManager getInstance() {
        LicenseManager licManager = new LicenseManager();
        return licManager;
    }

    private LicenseManager() {
    }

    private void init() throws InvalidLicenseException {
        InputStream inStream = this.getClass().getClassLoader().getResourceAsStream(CONFIG_PROPERTIES_FILE_PATH);
        Properties prop = new Properties();
        try {
            prop.loadFromXML(inStream);
            String className = prop.getProperty(CLASS_NAME);
            if (className == null || className.trim().length() == 0) {
                throw new RuntimeException("The name of the license manager reader class file is not specified in com/tandbergtv/workflow/core/licensing/license-config.properties");
            }
            Class<?> clazz = Class.forName(className);
            licenseReader = (ILicenseReader)clazz.newInstance();
        }
        catch (Exception e) {
            throw new InvalidLicenseException("Exception during initialization ", e);
        }
    }

    private LicenseKey getLicenseKey() throws InvalidLicenseException {
        LicenseKey licenseKey = null;
        licenseKey = licenseReader.getLicense(PASSWORD);
        return licenseKey;
    }

    public String getObject(String keyValue) throws InvalidLicenseException {
        this.init();
        LicenseKey licenseKey = this.getLicenseKey();
        String result = null;
        if (licenseKey != null) {
            Map<String, String> licenseMap = licenseKey.getLicenseMap();
            result = licenseMap.get(keyValue);
        }
        return result;
    }

    public boolean isExpirationDateValid() {
        boolean result = false;
        try {
            String dateString = this.getObject(EXPIRATION_DATE);
            SimpleDateFormat dfDate = new SimpleDateFormat("yyyy-MM-dd");
            Date licenseDate = null;
            if (dateString != null && dateString.length() > 0) {
                licenseDate = dfDate.parse(dateString);
                logger.debug((Object)("License date: " + licenseDate));
            }
            Date currentDate = new Date();
            if (licenseDate != null && currentDate.after(licenseDate)) {
                throw new InvalidLicenseException("License date has expired on " + licenseDate);
            }
            result = true;
        }
        catch (Exception e) {
            logger.error((Object)"Exception while checking the license: ", (Throwable)e);
            return false;
        }
        return result;
    }

    static {
        logger = Logger.getLogger(LicenseManager.class);
    }
}

