/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core.licensing.file;

import com.tandbergtv.workflow.core.licensing.EncryptionUtil;
import com.tandbergtv.workflow.core.licensing.ILicenseReader;
import com.tandbergtv.workflow.core.licensing.InvalidLicenseException;
import com.tandbergtv.workflow.core.licensing.LicenseKey;
import com.tandbergtv.workflow.core.licensing.LicenseKeyConstants;
import com.tandbergtv.workflow.util.ApplicationProperties;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Properties;
import org.apache.log4j.Logger;

public class FileLicenseReader
implements ILicenseReader {
    private static final String ENCRYPTED_FILE_NAME = "licensekey.lic";
    private static Logger logger = Logger.getLogger(FileLicenseReader.class);

    @Override
    public LicenseKey getLicense(String password) throws InvalidLicenseException {
        File file = null;
        try {
            String path = this.getFilePath();
            file = new File(path);
            if (!file.exists()) {
                logger.error((Object)("[Configuration Error] licensekey.lic " + file.getAbsolutePath() + " license file not found"));
                throw new InvalidLicenseException("License file not found");
            }
        }
        catch (IOException e) {
            throw new InvalidLicenseException("Cannot determine license file location", e);
        }
        LicenseKey license = new LicenseKey();
        InputStream is = null;
        try {
            is = new EncryptionUtil().getEncryptedInputStream(password, file.getAbsolutePath());
            Properties properties = new Properties();
            properties.loadFromXML(is);
            HashMap<String, String> map = new HashMap<String, String>();
            for (String name : LicenseKeyConstants.licenseParams) {
                String value = properties.getProperty(name);
                map.put(name, value);
                logger.debug((Object)(name + "-" + value));
            }
            license.setLicenseMap(map);
        }
        catch (Exception e) {
            throw new InvalidLicenseException("Could not read properties from the encrypted input stream", e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        return license;
    }

    protected String getFilePath() throws IOException {
        return ApplicationProperties.getInstance().getProperty("WorkflowApp.ConfigPath") + File.separator + ENCRYPTED_FILE_NAME;
    }
}

