/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.log;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.core.event.ColleaguePriority;
import com.tandbergtv.workflow.core.event.DefaultMediator;
import com.tandbergtv.workflow.core.event.IColleague;
import com.tandbergtv.workflow.core.event.WorkflowEvent;
import com.tandbergtv.workflow.core.graph.NodeVisitor;
import com.tandbergtv.workflow.core.queue.monitor.IQueueMonitor;
import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.log.LogQueueDrainer;
import com.tandbergtv.workflow.log.entities.WorkflowMessageLog;
import com.tandbergtv.workflow.log.entities.WorkflowNodeLog;
import com.tandbergtv.workflow.log.hibernate.WorkflowMessageLogHDAO;
import com.tandbergtv.workflow.log.hibernate.WorkflowNodeLogHDAO;
import com.tandbergtv.workflow.log.loggers.IWorkflowLogger;
import com.tandbergtv.workflow.log.mgmt.EventQueue;
import com.tandbergtv.workflow.util.ApplicationProperties;
import com.tandbergtv.workflow.util.SortingOrder;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.apache.log4j.Logger;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.exe.Token;
import org.jbpm.graph.log.NodeLog;

public class WorkflowLogManager
implements IColleague,
Service {
    private static final String QUERY_CLAUSE = "from NodeLog n where n.token.id in (:tokenIDs) and n.node.id in (:nodeIDs) order by n.date";
    private static final String SELECT = "select n ";
    private static final String COUNT = "select count(*) ";
    private static final String BUFFER_SUFFIX = ".buffer";
    private static final String BUFFER_TIMEOUT_SUFFIX = ".buffer.timeout";
    private static final String QUEUE_SUFFIX = ".queue";
    private static final String MBEAN_NAME_PREFIX = "com.tandbergtv.watchpoint:type=Queue,category=Logger,name=";
    private static final Logger logger = Logger.getLogger(WorkflowLogManager.class);
    private boolean initialized = false;
    private List<LogQueueDrainer> drainers = new ArrayList<LogQueueDrainer>();
    private SessionFactory factory;

    private WorkflowLogManager() {
    }

    public WorkflowLogManager(SessionFactory factory) {
        this();
        this.factory = factory;
    }

    public String getServiceName() {
        return "Logger";
    }

    public void start() {
        if (this.initialized) {
            logger.info((Object)"Workflow Log Manager already initialized. Ignoring the initialize() call.");
            return;
        }
        logger.debug((Object)"Initializing the Workflow Log Manager...");
        this.configure();
        DefaultMediator.getInstance().register((IColleague)this);
        this.initialized = true;
    }

    public void stop() {
        logger.debug((Object)"Destroying the Workflow Log Manager...");
        DefaultMediator.getInstance().unregister((IColleague)this);
        for (LogQueueDrainer drainer : this.drainers) {
            drainer.stop();
            this.unregisterMBean(MBEAN_NAME_PREFIX + drainer.getName());
        }
        this.drainers.clear();
        this.initialized = false;
    }

    protected SessionFactory getSessionFactory() {
        return this.factory;
    }

    protected Session getSession() {
        return this.getSessionFactory().openSession();
    }

    public String getColleagueName() {
        return this.getClass().getName();
    }

    public ColleaguePriority getColleaguePriority() {
        return ColleaguePriority.LOW;
    }

    public void receive(WorkflowEvent event) {
        logger.debug((Object)("Adding to the drainer: " + event));
        for (LogQueueDrainer drainer : this.drainers) {
            drainer.drainEvent(event);
        }
        logger.debug((Object)"Added...");
    }

    private void configure() {
        Properties properties = this.getConfiguration();
        for (Object key : properties.keySet()) {
            String category = (String)key;
            if (category.contains(".")) continue;
            String[] classNames = properties.getProperty(category).split(",");
            IWorkflowLogger[] loggers = new IWorkflowLogger[classNames.length];
            int queueCount = Integer.valueOf(properties.getProperty(category + QUEUE_SUFFIX));
            int i = 0;
            for (String className : classNames) {
                try {
                    logger.debug((Object)("Class name " + className));
                    Class<?> clazz = this.getClass().getClassLoader().loadClass(className.trim());
                    Constructor<?> constructor = clazz.getConstructor(SessionFactory.class, Integer.class);
                    loggers[i++] = (IWorkflowLogger)constructor.newInstance(this.getSessionFactory(), queueCount);
                }
                catch (Throwable t) {
                    logger.warn((Object)("Failed to create logger " + className + ", events of category " + category + " will not be saved"), t);
                }
            }
            int size = Integer.valueOf(properties.getProperty(category + BUFFER_SUFFIX));
            int timeout = 30;
            try {
                timeout = Integer.valueOf(properties.getProperty(category + BUFFER_TIMEOUT_SUFFIX));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            this.addDrainers(category, size, timeout, queueCount, loggers);
        }
    }

    private void addDrainers(String category, int bufferSize, int bufferDrainTimeout, int count, IWorkflowLogger ... loggers) {
        for (int i = 0; i < count; ++i) {
            LogQueueDrainer drainer = new LogQueueDrainer(category, i, bufferSize, bufferDrainTimeout, this.factory, loggers);
            this.drainers.add(drainer);
            this.registerMBean(new EventQueue(drainer), MBEAN_NAME_PREFIX + drainer.getName());
            drainer.start();
        }
    }

    private Properties getConfiguration() {
        Properties properties = new Properties();
        try {
            ApplicationProperties props = ApplicationProperties.getInstance();
            File file = new File(props.getProperty("WorkflowApp.ConfigPath"), "logger.properties");
            if (file.exists()) {
                properties.load(new FileInputStream(file));
                return properties;
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        ResourceBundle bundle = ResourceBundle.getBundle(this.getClass().getPackage().getName() + ".logger");
        for (String key : bundle.keySet()) {
            properties.put(key, bundle.getString(key));
        }
        return properties;
    }

    private void registerMBean(IQueueMonitor monitor, String name) {
        try {
            ManagementFactory.getPlatformMBeanServer().registerMBean(new StandardMBean(monitor, IQueueMonitor.class), new ObjectName(name));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void unregisterMBean(String name) {
        try {
            ManagementFactory.getPlatformMBeanServer().unregisterMBean(new ObjectName(name));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<NodeLog> getHistoryTasks(List<CustomToken> tokens, int numRecords, int startingRecordNum) {
        List jbpmNodeLogs;
        Session session = this.getSession();
        try {
            Query query = session.createQuery(this.buildHistoryTasksQuery(false));
            query.setParameterList("tokenIDs", this.getTokenIDList(tokens));
            query.setParameterList("nodeIDs", this.getNodeIDList(tokens));
            query.setMaxResults(numRecords);
            query.setFirstResult(startingRecordNum);
            jbpmNodeLogs = query.list();
        }
        finally {
            session.close();
        }
        return jbpmNodeLogs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getHistoryTasksCount(List<CustomToken> tokens) {
        Session session = this.getSession();
        try {
            Query query = session.createQuery(this.buildHistoryTasksQuery(true));
            query.setParameterList("tokenIDs", this.getTokenIDList(tokens));
            query.setParameterList("nodeIDs", this.getNodeIDList(tokens));
            int n = ((Number)query.uniqueResult()).intValue();
            return n;
        }
        finally {
            session.close();
        }
    }

    private String buildHistoryTasksQuery(boolean count) {
        StringBuffer query = null;
        query = count ? new StringBuffer(COUNT) : new StringBuffer(SELECT);
        query.append(QUERY_CLAUSE);
        return query.toString();
    }

    private List<Long> getTokenIDList(List<CustomToken> tokens) {
        ArrayList<Long> tokenIDList = new ArrayList<Long>();
        for (CustomToken token : tokens) {
            tokenIDList.add(token.getId());
        }
        return tokenIDList;
    }

    private List<Long> getNodeIDList(List<CustomToken> tokens) {
        final ArrayList<Long> nodes = new ArrayList<Long>();
        WorkflowTemplate template = tokens.get(0).getProcessInstance().getProcessDefinition();
        template.breadthFirstTraversal(new NodeVisitor(){

            public void visit(Node node) {
                nodes.add(node.getId());
            }
        });
        return nodes;
    }

    public List<WorkflowMessageLog> getHistoryTaskMessages(long historyTaskMessagesKey, int numRecords, int startingRecordNum, String sortColumn, SortingOrder sortOrder) {
        WorkflowMessageLogHDAO messageLogDAO = new WorkflowMessageLogHDAO(this.getSession());
        return messageLogDAO.findByJBPMNodeLogID(historyTaskMessagesKey, numRecords, startingRecordNum, sortColumn, sortOrder);
    }

    public int getHistoryTaskMessagesCount(long historyTaskMessagesKey) {
        WorkflowMessageLogHDAO messageLogDAO = new WorkflowMessageLogHDAO(this.getSession());
        return messageLogDAO.countByJBPMNodeLogID(historyTaskMessagesKey);
    }

    public List<WorkflowMessageLog> getCurrentTaskMessages(long currentTaskMessagesKey, int numRecords, int startingRecordNum, String sortColumn, SortingOrder sortOrder) {
        WorkflowMessageLogHDAO messageLogDAO = new WorkflowMessageLogHDAO(this.getSession());
        return messageLogDAO.findByWorkflowNodeLogID(currentTaskMessagesKey, numRecords, startingRecordNum, sortColumn, sortOrder);
    }

    public int getCurrentTaskMessagesCount(long currentTaskMessagesKey) {
        WorkflowMessageLogHDAO messageLogDAO = new WorkflowMessageLogHDAO(this.getSession());
        return messageLogDAO.countByWorkflowNodeLogID(currentTaskMessagesKey);
    }

    public long getCurrentTaskMessagesKey(Token token, Node node) {
        WorkflowNodeLogHDAO wfsNodeLogDAO = new WorkflowNodeLogHDAO(this.getSession());
        WorkflowNodeLog workflowNodeLog = wfsNodeLogDAO.findCurrentByTokenAndNode(token, node);
        return workflowNodeLog != null ? workflowNodeLog.getId() : -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getHistoryTaskIteration(long historyTaskID) {
        Session session = this.getSession();
        try {
            String queryString = "select count(*) from NodeLog n where n.node.id = (select n1.node.id from NodeLog n1 where n1.id = " + historyTaskID + ") and n.token.processInstance = (select n2.token.processInstance from NodeLog n2 where n2.id = " + historyTaskID + ") and n.id <= " + historyTaskID;
            Query query = session.createQuery(queryString);
            int n = ((Long)query.uniqueResult()).intValue();
            return n;
        }
        catch (Exception e) {
            logger.error((Object)("Exception while trying to get iteration number of history task | historyTaskID: " + historyTaskID), (Throwable)e);
            int n = -1;
            return n;
        }
        finally {
            session.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getHistoryTaskNumIterations(long historyTaskID) {
        Session session = this.getSession();
        try {
            String queryString = "select count(wnl) from WorkflowNodeLog wnl, NodeLog nl where wnl.node = nl.node and wnl.token.processInstance = nl.token.processInstance and nl.id = " + historyTaskID;
            Query query = session.createQuery(queryString);
            int n = ((Long)query.uniqueResult()).intValue();
            return n;
        }
        catch (Exception e) {
            logger.error((Object)("Exception while trying to get total # iterations of history task | historyTaskID: " + historyTaskID), (Throwable)e);
            int n = -1;
            return n;
        }
        finally {
            session.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCurrentTaskIteration(long currentTaskMessagesKey) {
        Session session = this.getSession();
        try {
            String queryString = "select count(*) from WorkflowNodeLog wnl where wnl.node.id = (select wnl1.node.id from WorkflowNodeLog wnl1 where wnl1.id = " + currentTaskMessagesKey + ") and wnl.token.processInstance = (select wnl2.token.processInstance from WorkflowNodeLog wnl2 where wnl2.id = " + currentTaskMessagesKey + ") and wnl.id <= " + currentTaskMessagesKey;
            Query query = session.createQuery(queryString);
            int n = ((Long)query.uniqueResult()).intValue();
            return n;
        }
        catch (Exception e) {
            logger.error((Object)("Exception while trying to get iteration number of current task | currentTaskMessagesKey: " + currentTaskMessagesKey), (Throwable)e);
            int n = -1;
            return n;
        }
        finally {
            session.close();
        }
    }
}

