/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.message.command.internal;

import com.tandbergtv.watchpoint.boot.Platform;
import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.message.WPCLCommand;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.command.AbstractCommand;
import com.tandbergtv.workflow.message.command.CommandException;
import com.tandbergtv.workflow.message.command.CompositeCommand;
import com.tandbergtv.workflow.message.command.ICommand;
import com.tandbergtv.workflow.message.command.ICommandExecutor;
import java.lang.reflect.Constructor;
import org.apache.log4j.Logger;
import org.java.plugin.PluginManager;
import org.java.plugin.registry.Extension;
import org.java.plugin.registry.ExtensionPoint;
import org.java.plugin.registry.PluginDescriptor;

public class CommandExecutor
implements ICommandExecutor,
Service {
    private static final String PLUGIN_ID = "com.tandbergtv.workflow.message";
    private static final String EXTENSION_POINT = "command";
    private static final String DECORATOR_EXTENSION_POINT = "decorator";
    private static final String DECORATOR_COMMAND = "decorator";
    private static final String THROTTLE_PARAMETER = "throttle";
    private static final String ALIAS_PARAMETER = "alias";
    private static final String CLASS_PARAMETER = "class";
    private static final Logger logger = Logger.getLogger(CommandExecutor.class);

    public WorkflowMessage execute(WorkflowMessage message) {
        WorkflowMessage response = null;
        ICommand cmd = this.getCommand(message);
        try {
            logger.debug((Object)("Executing command : " + cmd.getClass().getSimpleName()));
            response = this.getDecoratedCommand(cmd).execute();
        }
        catch (CommandException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CommandException("Error executing command for message " + message.getMessageUID(), (Throwable)e);
        }
        return response;
    }

    public WorkflowMessage executeImmediate(WorkflowMessage message) {
        WorkflowMessage response = null;
        ICommand cmd = this.getCommand(message);
        try {
            logger.debug((Object)("Executing command : " + cmd.getClass().getSimpleName()));
            response = cmd.execute();
        }
        catch (CommandException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CommandException("Error executing command for message " + message.getMessageUID(), (Throwable)e);
        }
        return response;
    }

    public String getServiceName() {
        return "Command Executor";
    }

    public void start() {
    }

    public void stop() {
    }

    private ICommand getCommand(WorkflowMessage message) {
        ICommand cmd = null;
        WPCLCommand command = WPCLCommand.NULL;
        if (message.getCommand() != null) {
            command = message.getCommand();
        }
        try {
            Extension extension = this.getCommandExtension(command.getName());
            cmd = this.createCommand(extension, message);
            Extension decoratorExtension = this.getCommandDecoratorExtension(extension);
            if (decoratorExtension != null) {
                return this.createCompositeCommand(decoratorExtension, cmd);
            }
        }
        catch (CommandException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CommandException("Could not get command for message " + message.getMessageUID(), (Throwable)e);
        }
        return cmd;
    }

    private Extension getCommandDecoratorExtension(Extension e) {
        PluginManager pm = Platform.getPlatform().getPluginManager();
        ExtensionPoint point = pm.getRegistry().getExtensionPoint(PLUGIN_ID, "decorator");
        for (Extension extension : point.getAvailableExtensions()) {
            Extension.Parameter param = extension.getParameter("extension-id");
            if (param == null || !e.getId().equalsIgnoreCase(param.valueAsString())) continue;
            return extension;
        }
        return null;
    }

    private ICommand createCommand(Extension extension, WorkflowMessage message) throws Exception {
        Extension.Parameter parameter;
        String className = extension.getParameter(CLASS_PARAMETER).valueAsString();
        PluginDescriptor desc = extension.getDeclaringPluginDescriptor();
        PluginManager pm = Platform.getPlatform().getPluginManager();
        Class clazz = pm.getPluginClassLoader(desc).loadClass(className);
        Constructor ctor = clazz.getConstructor(WorkflowMessage.class);
        ICommand command = (ICommand)ctor.newInstance(message);
        if (command instanceof AbstractCommand && (parameter = extension.getParameter(THROTTLE_PARAMETER)) != null) {
            ((AbstractCommand)AbstractCommand.class.cast(command)).setThrottle(parameter.valueAsBoolean().booleanValue());
        }
        return command;
    }

    private ICommand getDecoratedCommand(ICommand decoratee) throws Exception {
        Extension extension = this.getCommandExtension("decorator");
        if (extension == null) {
            return decoratee;
        }
        return this.createCompositeCommand(extension, decoratee);
    }

    private CompositeCommand createCompositeCommand(Extension extension, ICommand decoratee) throws Exception {
        String className = extension.getParameter(CLASS_PARAMETER).valueAsString();
        PluginDescriptor desc = extension.getDeclaringPluginDescriptor();
        PluginManager pm = Platform.getPlatform().getPluginManager();
        Class clazz = pm.getPluginClassLoader(desc).loadClass(className);
        Constructor ctor = clazz.getConstructor(ICommand.class);
        return (CompositeCommand)ctor.newInstance(decoratee);
    }

    private Extension getCommandExtension(String name) {
        PluginManager pm = Platform.getPlatform().getPluginManager();
        ExtensionPoint point = pm.getRegistry().getExtensionPoint(PLUGIN_ID, EXTENSION_POINT);
        for (Extension extension : point.getAvailableExtensions()) {
            Extension.Parameter parameter = extension.getParameter(ALIAS_PARAMETER);
            if (!name.equalsIgnoreCase(parameter.valueAsString())) continue;
            return extension;
        }
        throw new CommandException("Command not found: " + name);
    }
}

